"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AbstractDashboardDrilldown = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/presentation-util-plugin/public");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _components = require("./components");
var _i18n = require("./i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dashboard_enhanced/public/services/drilldowns/abstract_dashboard_drilldown/abstract_dashboard_drilldown.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class AbstractDashboardDrilldown {
  constructor(params) {
    (0, _defineProperty2.default)(this, "order", 100);
    (0, _defineProperty2.default)(this, "getDisplayName", () => _i18n.txtGoToDashboard);
    (0, _defineProperty2.default)(this, "euiIcon", 'dashboardApp');
    (0, _defineProperty2.default)(this, "ReactCollectConfig", void 0);
    (0, _defineProperty2.default)(this, "CollectConfig", void 0);
    (0, _defineProperty2.default)(this, "createConfig", () => ({
      dashboardId: '',
      ..._public.DEFAULT_DASHBOARD_DRILLDOWN_OPTIONS
    }));
    (0, _defineProperty2.default)(this, "isConfigValid", config => {
      if (!config.dashboardId) return false;
      return true;
    });
    (0, _defineProperty2.default)(this, "getHref", async (config, context) => {
      const {
        app,
        path
      } = await this.getLocation(config, context, true);
      const url = await this.params.start().core.application.getUrlForApp(app, {
        path,
        absolute: true
      });
      return url;
    });
    (0, _defineProperty2.default)(this, "execute", async (config, context) => {
      if (config.openInNewTab) {
        window.open(await this.getHref(config, context), '_blank');
      } else {
        const {
          app,
          path,
          state
        } = await this.getLocation(config, context, false);
        await this.params.start().core.application.navigateToApp(app, {
          path,
          state
        });
      }
    });
    this.params = params;
    this.ReactCollectConfig = props => /*#__PURE__*/_react.default.createElement(_components.CollectConfigContainer, (0, _extends2.default)({}, props, {
      params: this.params,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 42
      }
    }));
    this.CollectConfig = this.ReactCollectConfig;
  }
  get locator() {
    const locator = this.params.start().plugins.share.url.locators.get(_deeplinksAnalytics.DASHBOARD_APP_LOCATOR);
    if (!locator) throw new Error('Dashboard locator is required for dashboard drilldown.');
    return locator;
  }
}
exports.AbstractDashboardDrilldown = AbstractDashboardDrilldown;