"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isWriteBlockException = exports.isIndexNotFoundException = exports.isIncompatibleMappingException = exports.isClusterShardLimitExceeded = exports.hasAllKeywordsInOrder = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isWriteBlockException = errorCause => {
  return (errorCause === null || errorCause === void 0 ? void 0 : errorCause.type) === 'cluster_block_exception' && hasAllKeywordsInOrder(errorCause === null || errorCause === void 0 ? void 0 : errorCause.reason, ['index [', '] blocked by: [FORBIDDEN/8/', ' (api)]']);
};
exports.isWriteBlockException = isWriteBlockException;
const isIncompatibleMappingException = errorCause => {
  return (errorCause === null || errorCause === void 0 ? void 0 : errorCause.type) === 'strict_dynamic_mapping_exception' || (errorCause === null || errorCause === void 0 ? void 0 : errorCause.type) === 'mapper_parsing_exception' || (errorCause === null || errorCause === void 0 ? void 0 : errorCause.type) === 'document_parsing_exception';
};
exports.isIncompatibleMappingException = isIncompatibleMappingException;
const isIndexNotFoundException = errorCause => {
  return (errorCause === null || errorCause === void 0 ? void 0 : errorCause.type) === 'index_not_found_exception';
};
exports.isIndexNotFoundException = isIndexNotFoundException;
const isClusterShardLimitExceeded = errorCause => {
  // traditional ES: validation_exception. serverless ES: illegal_argument_exception
  return ((errorCause === null || errorCause === void 0 ? void 0 : errorCause.type) === 'validation_exception' || (errorCause === null || errorCause === void 0 ? void 0 : errorCause.type) === 'illegal_argument_exception') && hasAllKeywordsInOrder(errorCause === null || errorCause === void 0 ? void 0 : errorCause.reason, ['this action would add', 'shards, but this cluster currently has', 'maximum', 'shards open']);
};
exports.isClusterShardLimitExceeded = isClusterShardLimitExceeded;
const hasAllKeywordsInOrder = (message, keywords) => {
  if (!message || !keywords.length) {
    return false;
  }
  const keywordIndices = keywords.map(keyword => {
    var _message$indexOf;
    return (_message$indexOf = message === null || message === void 0 ? void 0 : message.indexOf(keyword)) !== null && _message$indexOf !== void 0 ? _message$indexOf : -1;
  });
  // check that all keywords are present and in the right order
  return keywordIndices.every((v, i, a) => v >= 0 && (!i || a[i - 1] <= v));
};
exports.hasAllKeywordsInOrder = hasAllKeywordsInOrder;