"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultSettingsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _settings_logic = require("./settings_logic");
var _settings_panel = require("./settings_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/settings/default_settings_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Callout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  title: _i18n.i18n.translate('xpack.contentConnectors.defaultSettingsFlyout.callout.title', {
    defaultMessage: 'Individual settings management'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 40,
    columnNumber: 3
  }
}, _i18n.i18n.translate('xpack.contentConnectors.defaultSettingsFlyout.callout.body', {
  defaultMessage: 'You can also enable or disable this feature for a specific index on the index’s configuration page.'
}));
const DefaultSettingsFlyout = ({
  closeFlyout
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    services: {
      http,
      docLinks
    }
  } = (0, _public.useKibana)();
  const {
    makeRequest,
    setPipeline
  } = (0, _kea.useActions)((0, _settings_logic.SettingsLogic)({
    http
  }));
  const {
    defaultPipeline,
    hasNoChanges,
    isLoading,
    pipelineState
  } = (0, _kea.useValues)((0, _settings_logic.SettingsLogic)({
    http
  }));
  const {
    extract_binary_content: extractBinaryContent,
    reduce_whitespace: reduceWhitespace,
    run_ml_inference: runMLInference
  } = pipelineState;
  // Reference the first focusable element in the flyout for accessibility on click or Enter key action either Reset or Save button
  const firstFocusInFlyoutRef = (0, _react.useRef)(null);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: closeFlyout,
    size: "s",
    paddingSize: "l",
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.defaultSettingsFlyout.h2.defaultSettingsLabel', {
    defaultMessage: 'Default Settings'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    banner: Callout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.contentConnectors..defaultSettingsFlyout.body.description.label",
    defaultMessage: "These settings apply to all new Elasticsearch indices created by Search ingestion mechanisms. For API ingest-based indices, remember to include the pipeline when you ingest documents. These features are powered by {link}",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "entSearchContent-defaultSettingsFlyout-ingestPipelinesLink",
        "data-telemetry-id": "entSearchContent-defaultSettingsFlyout-ingestPipelinesLink",
        href: docLinks === null || docLinks === void 0 ? void 0 : docLinks.links.ingest.pipelines,
        target: "_blank",
        ref: firstFocusInFlyoutRef,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 19
        }
      }, _i18n.i18n.translate('xpack.contentConnectors.defaultSettingsFlyout.body.description.ingestPipelinesLink.link', {
        defaultMessage: 'ingest pipelines'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_settings_panel.SettingsPanel, {
    description: _i18n.i18n.translate('xpack.contentConnectors.content.settings.contentExtraction.description', {
      defaultMessage: 'Extract searchable content from binary files, like PDFs and Word documents.'
    }),
    label: _i18n.i18n.translate('xpack.contentConnectors.content.settings.contactExtraction.label', {
      defaultMessage: 'Content extraction'
    }),
    onChange: () => setPipeline({
      ...pipelineState,
      extract_binary_content: !pipelineState.extract_binary_content
    }),
    title: _i18n.i18n.translate('xpack.contentConnectors.content.settings.contentExtraction.title', {
      defaultMessage: 'Deployment wide content extraction'
    }),
    value: extractBinaryContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_settings_panel.SettingsPanel, {
    description: _i18n.i18n.translate('xpack.contentConnectors.content.settings.whiteSpaceReduction.description', {
      defaultMessage: 'Whitespace reduction will strip your full-text content of whitespace by default.'
    }),
    label: _i18n.i18n.translate('xpack.contentConnectors.content.settings.whitespaceReduction.label', {
      defaultMessage: 'Whitespace reduction'
    }),
    onChange: () => setPipeline({
      ...pipelineState,
      reduce_whitespace: !pipelineState.reduce_whitespace
    }),
    title: _i18n.i18n.translate('xpack.contentConnectors.content.settings.whitespaceReduction.deploymentHeaderTitle', {
      defaultMessage: 'Deployment wide whitespace reduction'
    }),
    value: reduceWhitespace,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_settings_panel.SettingsPanel, {
    description: _i18n.i18n.translate('xpack.contentConnectors.content.settings.mlInference.description', {
      defaultMessage: 'ML Inference Pipelines will run as part of your pipelines. You will have to configure processors for each index individually on its pipelines page.'
    }),
    label: _i18n.i18n.translate('xpack.contentConnectors.content.settings.mlInference.label', {
      defaultMessage: 'ML Inference'
    }),
    link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "entSearchContent-defaultSettingsFlyout-mlInferenceLink",
      "data-telemetry-id": "entSearchContent-defaultSettingsFlyout-mlInferenceLink",
      href: docLinks === null || docLinks === void 0 ? void 0 : docLinks.links.enterpriseSearch.mlDocumentEnrichment,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.contentConnectors.content.settings.mlInference.link', {
      defaultMessage: 'Learn more about document enrichment with ML'
    })),
    onChange: () => setPipeline({
      ...pipelineState,
      run_ml_inference: !pipelineState.run_ml_inference
    }),
    title: _i18n.i18n.translate('xpack.contentConnectors.content.settings.mlInference.deploymentHeaderTitle', {
      defaultMessage: 'Deployment wide ML Inference Pipelines extraction'
    }),
    value: runMLInference,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => closeFlyout(),
    "data-test-subj": 'entSearchContentSettingsCancelButtonButton',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.content.settings.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    disabled: hasNoChanges,
    isLoading: isLoading,
    onClick: () => {
      var _firstFocusInFlyoutRe;
      setPipeline(defaultPipeline);
      (_firstFocusInFlyoutRe = firstFocusInFlyoutRef.current) === null || _firstFocusInFlyoutRe === void 0 ? void 0 : _firstFocusInFlyoutRe.focus();
    },
    "data-test-subj": 'entSearchContentSettingsResetButton',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.content.settings.resetButtonLabel', {
    defaultMessage: 'Reset'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    disabled: hasNoChanges,
    isLoading: isLoading,
    onClick: () => {
      var _firstFocusInFlyoutRe2;
      makeRequest({
        ...pipelineState,
        http
      });
      (_firstFocusInFlyoutRe2 = firstFocusInFlyoutRef.current) === null || _firstFocusInFlyoutRe2 === void 0 ? void 0 : _firstFocusInFlyoutRe2.focus();
    },
    "data-test-subj": 'entSearchContentSettingsSaveButton',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.content.settings.saveButtonLabel', {
    defaultMessage: 'Save'
  }))))))));
};
exports.DefaultSettingsFlyout = DefaultSettingsFlyout;