"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorSyncRules = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _searchConnectors = require("@kbn/search-connectors");
var _public = require("@kbn/kibana-react-plugin/public");
var _sync_rules_helpers = require("../../../../utils/sync_rules_helpers");
var _connector_view_logic = require("../../../connector_detail/connector_view_logic");
var _connector_filtering_logic = require("./connector_filtering_logic");
var _edit_sync_rules_flyout = require("./edit_sync_rules_flyout");
var _sync_rules_callouts = require("./sync_rules_callouts");
var _doc_links = require("../../../shared/doc_links");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/search_index/connector/sync_rules/connector_rules.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConnectorSyncRules = () => {
  const {
    services: {
      http
    }
  } = (0, _public.useKibana)();
  const {
    indexName,
    hasAdvancedFilteringFeature,
    hasBasicFilteringFeature
  } = (0, _kea.useValues)((0, _connector_view_logic.ConnectorViewLogic)({
    http
  }));
  const {
    applyDraft,
    setLocalFilteringRules,
    setLocalAdvancedSnippet,
    setIsEditing
  } = (0, _kea.useActions)((0, _connector_filtering_logic.ConnectorFilteringLogic)({
    http
  }));
  const {
    advancedSnippet,
    draftErrors,
    draftState,
    filteringRules,
    hasDraft,
    isEditing
  } = (0, _kea.useValues)((0, _connector_filtering_logic.ConnectorFilteringLogic)({
    http
  }));
  const isAdvancedSnippetEmpty = (0, _sync_rules_helpers.isAdvancedSyncRuleSnippetEmpty)(advancedSnippet);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isEditing && /*#__PURE__*/_react.default.createElement(_edit_sync_rules_flyout.EditSyncRulesFlyout, {
    errors: draftErrors,
    hasAdvancedFilteringFeature: hasAdvancedFilteringFeature,
    hasBasicFilteringFeature: hasBasicFilteringFeature,
    revertLocalFilteringRules: () => setLocalFilteringRules(filteringRules),
    revertLocalAdvancedFiltering: () => setLocalAdvancedSnippet(advancedSnippet),
    setIsEditing: setIsEditing,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, hasDraft && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_sync_rules_callouts.SyncRulesStateCallouts, {
    applyDraft: applyDraft,
    editDraft: () => setIsEditing(true),
    state: draftState,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.index.connector.syncRules.description', {
    defaultMessage: `Include or exclude high level items, file types and (file or folder) paths to
                    synchronize from {indexName}. Everything is included by default. Each document is
                    tested against the rules below and the first rule that matches will be applied.`,
    values: {
      indexName
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "entSearchContent-connector-syncRules-learnMoreLink",
    "data-telemetry-id": "entSearchContent-connector-syncRules-learnMoreLink",
    href: _doc_links.docLinks.syncRules,
    external: true,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.index.connector.syncRules.syncRulesLabel', {
    defaultMessage: 'Learn more about sync rules'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enterprisecontentConnectors.yncRulesButton",
    "data-telemetry-id": "entSearchContent-connector-syncRules-editRules-editDraftRules",
    color: "primary",
    onClick: () => setIsEditing(!isEditing),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 15
    }
  }, hasDraft ? _i18n.i18n.translate('xpack.contentConnectors.index.connector.syncRules.editFilterRulesTitle', {
    defaultMessage: 'Edit sync rules'
  }) : _i18n.i18n.translate('xpack.contentConnectors.index.connector.syncRules.draftNewFilterRulesTitle', {
    defaultMessage: 'Draft new sync rules'
  }))))), hasBasicFilteringFeature && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "plain",
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.content.index.connector.syncRules.basicRulesTitle', {
    defaultMessage: 'Basic rules'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.content.index.connector.syncRules.basicRulesDescription', {
    defaultMessage: 'These rules apply to documents during the integration filtering phase.'
  })))), /*#__PURE__*/_react.default.createElement(_searchConnectors.FilteringRulesTable, {
    filteringRules: filteringRules,
    showOrder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 17
    }
  })))), hasAdvancedFilteringFeature && !isAdvancedSnippetEmpty && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "plain",
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.content.index.connector.syncRules.advancedRulesTitle', {
    defaultMessage: 'Advanced rules'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.content.index.connector.syncRules.advancedFiltersDescription', {
    defaultMessage: 'These rules apply before the data is obtained from the data source.'
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "entSearchContent-connector-syncRules-learnMoreLink",
    "data-telemetry-id": "entSearchContent-connector-syncRules-learnMoreLink",
    external: true,
    href: _doc_links.docLinks.syncRulesAdvanced,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 23
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.content.index.connector.syncRules.advancedFiltersLinkTitle', {
    defaultMessage: 'Learn more about advanced sync rules.'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    language: "json",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 17
    }
  }, advancedSnippet), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.contentConnectors.content.index.connector.syncRules.advancedRulesCalloutTitle', {
      defaultMessage: 'Configuration'
    }),
    color: "warning",
    iconType: "info",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 23
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.content.index.connector.syncRules.advancedRulesCalloutDescription', {
    defaultMessage: 'This advanced sync rule might override some configuration fields.'
  }))))))))));
};
exports.ConnectorSyncRules = ConnectorSyncRules;