"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.TruncatedCopyableText = exports.FindingsMisconfigurationFlyoutHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _findings_flyout = require("../findings_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/configurations/findings_flyout/findings_right/header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TruncatedCopyableText = ({
  textToCopy
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: {
      paddingTop: '4px',
      overflow: 'hidden'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: {
      float: 'left',
      overflow: 'hidden',
      whiteSpace: 'nowrap',
      textOverflow: 'ellipsis',
      maxWidth: 'calc(100% - 20px)',
      marginRight: '4px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, textToCopy), /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: textToCopy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    css: (0, _react2.css)`
              :hover {
                cursor: pointer;
              }
            `,
    onClick: copy,
    type: "copy",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  })));
};
exports.TruncatedCopyableText = TruncatedCopyableText;
const FindingsMisconfigurationFlyoutHeader = ({
  finding
}) => {
  var _finding$rule, _finding$resource, _finding$observer, _finding$rule2, _finding$rule2$benchm, _finding$rule3, _finding$rule3$benchm;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const rulesTags = finding === null || finding === void 0 ? void 0 : (_finding$rule = finding.rule) === null || _finding$rule === void 0 ? void 0 : _finding$rule.tags;
  const resourceName = finding === null || finding === void 0 ? void 0 : (_finding$resource = finding.resource) === null || _finding$resource === void 0 ? void 0 : _finding$resource.name;
  const vendor = finding === null || finding === void 0 ? void 0 : (_finding$observer = finding.observer) === null || _finding$observer === void 0 ? void 0 : _finding$observer.vendor;
  const ruleBenchmarkId = finding === null || finding === void 0 ? void 0 : (_finding$rule2 = finding.rule) === null || _finding$rule2 === void 0 ? void 0 : (_finding$rule2$benchm = _finding$rule2.benchmark) === null || _finding$rule2$benchm === void 0 ? void 0 : _finding$rule2$benchm.id;
  const ruleBenchmarkName = finding === null || finding === void 0 ? void 0 : (_finding$rule3 = finding.rule) === null || _finding$rule3 === void 0 ? void 0 : (_finding$rule3$benchm = _finding$rule3.benchmark) === null || _finding$rule3$benchm === void 0 ? void 0 : _finding$rule3$benchm.name;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }), rulesTags && rulesTags.map(tag => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    key: tag,
    color: 'hollow',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }, tag)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "none",
    paddingSize: "xl",
    css: {
      borderRight: 'solid 1px #D3DAE6',
      padding: '12px'
    },
    hasBorder: false,
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 23
    }
  }, "Resource Name")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: resourceName,
    position: "top",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(TruncatedCopyableText, {
    textToCopy: resourceName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 25
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "none",
    paddingSize: "xl",
    css: {
      borderRight: 'solid 1px #D3DAE6',
      padding: '12px'
    },
    hasBorder: false,
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 23
    }
  }, "Framework"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 23
    }
  }), ruleBenchmarkId && ruleBenchmarkName && /*#__PURE__*/_react.default.createElement(_findings_flyout.BenchmarkIcons, {
    benchmarkId: ruleBenchmarkId,
    benchmarkName: ruleBenchmarkName,
    size: 'l',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 25
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "none",
    paddingSize: "xl",
    css: {
      padding: '12px'
    },
    hasBorder: false,
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 23
    }
  }, "Vendor")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 21
    }
  }, " ", vendor, " ")))))))), /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          margin: ${euiTheme.size.s};
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 7
    }
  }));
};

// eslint-disable-next-line import/no-default-export
exports.FindingsMisconfigurationFlyoutHeader = FindingsMisconfigurationFlyoutHeader;
var _default = exports.default = FindingsMisconfigurationFlyoutHeader;