"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComplianceScoreBar = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireDefault(require("react"));
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _helpers = require("../../common/utils/helpers");
var _test_subjects = require("./test_subjects");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/components/compliance_score_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * This component will take 100% of the width set by the parent
 * */
const ComplianceScoreBar = ({
  totalPassed,
  totalFailed,
  size = 'm',
  overrideCss
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    getMisconfigurationStatusColor
  } = (0, _cloudSecurityPosture.useGetMisconfigurationStatusColor)();
  const complianceScore = (0, _helpers.calculatePostureScore)(totalPassed, totalFailed);

  // ensures the compliance bar takes full width of its parent
  const fullWidthTooltipCss = (0, _react.css)`
    width: 100%;
  `;
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    anchorProps: {
      css: overrideCss || fullWidthTooltipCss
    },
    content: _i18n.i18n.translate('xpack.csp.complianceScoreBar.tooltipTitle', {
      defaultMessage: '{failed} failed and {passed} passed findings',
      values: {
        passed: totalPassed,
        failed: totalFailed
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    css: (0, _react.css)`
              height: ${size === 'm' ? euiTheme.size.xs : '6px'};
              border-radius: ${euiTheme.border.radius.medium};
              overflow: hidden;
              gap: 1px;
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }, !totalPassed && !totalFailed && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
                  flex: 1;
                  background: ${getMisconfigurationStatusColor(_cloudSecurityPostureCommon.MISCONFIGURATION_STATUS.UNKNOWN)};
                `,
    "data-test-subj": _test_subjects.COMPLIANCE_SCORE_BAR_UNKNOWN,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 15
    }
  }), !!totalPassed && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
                  flex: ${totalPassed};
                  background: ${getMisconfigurationStatusColor(_cloudSecurityPostureCommon.MISCONFIGURATION_STATUS.PASSED)};
                `,
    "data-test-subj": _test_subjects.COMPLIANCE_SCORE_BAR_PASSED,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 15
    }
  }), !!totalFailed && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
                  flex: ${totalFailed};
                  background: ${getMisconfigurationStatusColor(_cloudSecurityPostureCommon.MISCONFIGURATION_STATUS.FAILED)};
                `,
    "data-test-subj": _test_subjects.COMPLIANCE_SCORE_BAR_FAILED,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react.css)`
            width: ${euiTheme.size.xxl};
            text-align: right;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "xs",
    "data-test-subj": _test_subjects.CSP_FINDINGS_COMPLIANCE_SCORE,
    css: (0, _react.css)`
              font-weight: ${euiTheme.font.weight.bold};
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }, `${complianceScore.toFixed(0)}%`))));
};
exports.ComplianceScoreBar = ComplianceScoreBar;