"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  ALL: true,
  STATUS_ICON_ARIA: true,
  CASE_OPENED: true,
  CASE_IN_PROGRESS: true,
  CASE_CLOSED: true
};
exports.STATUS_ICON_ARIA = exports.CASE_OPENED = exports.CASE_IN_PROGRESS = exports.CASE_CLOSED = exports.ALL = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../../common/translations");
Object.keys(_translations).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _translations[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _translations[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALL = exports.ALL = _i18n.i18n.translate('xpack.cases.status.all', {
  defaultMessage: 'All status'
});
const STATUS_ICON_ARIA = exports.STATUS_ICON_ARIA = _i18n.i18n.translate('xpack.cases.status.iconAria', {
  defaultMessage: 'Change status'
});
const CASE_OPENED = exports.CASE_OPENED = _i18n.i18n.translate('xpack.cases.caseView.caseOpened', {
  defaultMessage: 'Case opened'
});
const CASE_IN_PROGRESS = exports.CASE_IN_PROGRESS = _i18n.i18n.translate('xpack.cases.caseView.caseInProgress', {
  defaultMessage: 'Case in progress'
});
const CASE_CLOSED = exports.CASE_CLOSED = _i18n.i18n.translate('xpack.cases.caseView.caseClosed', {
  defaultMessage: 'Case closed'
});