"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.statuses = void 0;
var _config = require("@kbn/cases-components/src/status/config");
var _domain = require("../../../common/types/domain");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const statusConfiguration = (0, _config.getStatusConfiguration)();
const statuses = exports.statuses = {
  [_domain.CaseStatuses.open]: {
    ...statusConfiguration[_domain.CaseStatuses.open],
    actions: {
      single: {
        title: i18n.OPEN_CASE
      }
    },
    actionBar: {
      title: i18n.CASE_OPENED
    },
    button: {
      label: i18n.REOPEN_CASE
    },
    stats: {
      title: i18n.OPEN_CASES
    }
  },
  [_domain.CaseStatuses['in-progress']]: {
    ...statusConfiguration[_domain.CaseStatuses['in-progress']],
    actions: {
      single: {
        title: i18n.MARK_CASE_IN_PROGRESS
      }
    },
    actionBar: {
      title: i18n.CASE_IN_PROGRESS
    },
    button: {
      label: i18n.MARK_CASE_IN_PROGRESS
    },
    stats: {
      title: i18n.IN_PROGRESS_CASES
    }
  },
  [_domain.CaseStatuses.closed]: {
    ...statusConfiguration[_domain.CaseStatuses.closed],
    actions: {
      single: {
        title: i18n.CLOSE_CASE
      }
    },
    actionBar: {
      title: i18n.CASE_CLOSED
    },
    button: {
      label: i18n.CLOSE_CASE
    },
    stats: {
      title: i18n.CLOSED_CASES
    }
  }
};