"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.connectorsQueriesKeys = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const connectorsQueriesKeys = exports.connectorsQueriesKeys = {
  jira: ['jira'],
  resilient: ['resilient'],
  servicenow: ['servicenow'],
  jiraGetFieldsByIssueType: (connectorId, issueType) => [...connectorsQueriesKeys.jira, connectorId, 'getFields', issueType],
  jiraGetIssueTypes: connectorId => [...connectorsQueriesKeys.jira, connectorId, 'getIssueType'],
  jiraGetIssues: (connectorId, query) => [...connectorsQueriesKeys.jira, connectorId, 'getIssues', query],
  jiraGetIssue: (connectorId, id) => [...connectorsQueriesKeys.jira, connectorId, 'getIssue', id],
  resilientGetIncidentTypes: connectorId => [...connectorsQueriesKeys.resilient, connectorId, 'getIncidentTypes'],
  resilientGetSeverity: connectorId => [...connectorsQueriesKeys.resilient, connectorId, 'getSeverity'],
  servicenowGetChoices: (connectorId, fields) => [...connectorsQueriesKeys.servicenow, connectorId, 'getChoices', fields]
};