"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setClipboardData = exports.getClipboardData = void 0;
var _constants = require("../../common/lib/constants");
var _storage = require("./storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const setClipboardData = data => {
  (0, _storage.getLocalStorage)().set(_constants.LOCALSTORAGE_CLIPBOARD, JSON.stringify(data));
};
exports.setClipboardData = setClipboardData;
const getClipboardData = () => (0, _storage.getLocalStorage)().get(_constants.LOCALSTORAGE_CLIPBOARD);
exports.getClipboardData = getClipboardData;