"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUnifiedTraceErrors = getUnifiedTraceErrors;
exports.requiredFields = exports.optionalFields = void 0;
var _utils = require("@kbn/apm-data-access-plugin/server/utils");
var _server = require("@kbn/observability-plugin/server");
var _apm = require("../../../common/es_fields/apm");
var _as_mutable_array = require("../../../common/utils/as_mutable_array");
var _get_trace_items = require("./get_trace_items");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getUnifiedTraceErrors({
  apmEventClient,
  logsClient,
  traceId,
  docId,
  start,
  end
}) {
  const commonParams = {
    traceId,
    docId,
    start,
    end
  };
  const [apmErrors, unprocessedOtelErrors] = await Promise.all([(0, _get_trace_items.getApmTraceError)({
    apmEventClient,
    ...commonParams
  }), getUnprocessedOtelErrors({
    logsClient,
    ...commonParams
  })]);
  return {
    apmErrors,
    unprocessedOtelErrors,
    totalErrors: apmErrors.length + unprocessedOtelErrors.length
  };
}
const requiredFields = exports.requiredFields = (0, _as_mutable_array.asMutableArray)([_apm.SPAN_ID, _apm.ID]);
const optionalFields = exports.optionalFields = (0, _as_mutable_array.asMutableArray)([_apm.EXCEPTION_TYPE, _apm.EXCEPTION_MESSAGE, _apm.TIMESTAMP_US]);
async function getUnprocessedOtelErrors({
  logsClient,
  traceId,
  docId,
  start,
  end
}) {
  const response = await logsClient.search({
    query: {
      bool: {
        filter: [...(0, _server.rangeQuery)(start, end), ...(0, _server.termQuery)(_apm.TRACE_ID, traceId), ...(0, _server.termQuery)(_apm.SPAN_ID, docId)],
        should: [...(0, _server.termQuery)(_apm.OTEL_EVENT_NAME, 'exception'), ...(0, _server.existsQuery)(_apm.EXCEPTION_TYPE), ...(0, _server.existsQuery)(_apm.EXCEPTION_MESSAGE)],
        minimum_should_match: 1,
        must_not: {
          exists: {
            field: _apm.PROCESSOR_EVENT
          }
        }
      }
    },
    fields: [...requiredFields, ...optionalFields]
  });
  return response.hits.hits.map(hit => {
    var _event$span, _event$exception, _event$exception2;
    const event = (0, _utils.unflattenKnownApmEventFields)(hit.fields, requiredFields);
    if (!event) return null;
    return {
      id: hit._id,
      spanId: (_event$span = event.span) === null || _event$span === void 0 ? void 0 : _event$span.id,
      timestamp: event === null || event === void 0 ? void 0 : event.timestamp,
      error: {
        exception: {
          type: (_event$exception = event.exception) === null || _event$exception === void 0 ? void 0 : _event$exception.type,
          message: (_event$exception2 = event.exception) === null || _event$exception2 === void 0 ? void 0 : _event$exception2.message
        }
      }
    };
  }).filter(doc => !!doc);
}