"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HighlightedExitSpansTable = HighlightedExitSpansTable;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_map/diagnostic_tool/diagnostic_highlighted_exit_spans_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const columns = [{
  field: 'destinationService',
  name: _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticResults.table.destinationService', {
    defaultMessage: 'Destination Service'
  }),
  render: (value, item) => /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 66
    }
  }, value || /*#__PURE__*/_react.default.createElement("em", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 81
    }
  }, "\u2014"))
}, {
  field: 'agentName',
  name: _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticResults.table.agentName', {
    defaultMessage: 'Agent'
  }),
  render: value => value || /*#__PURE__*/_react.default.createElement("em", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 53
    }
  }, "\u2014")
}, {
  field: 'spanId',
  name: _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticResults.table.spanId', {
    defaultMessage: 'Span ID'
  }),
  render: value => value || /*#__PURE__*/_react.default.createElement("em", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 53
    }
  }, "\u2014")
}, {
  field: 'transactionId',
  name: _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticResults.table.transactionId', {
    defaultMessage: 'Transaction ID'
  }),
  render: value => value || /*#__PURE__*/_react.default.createElement("em", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 53
    }
  }, "\u2014")
}, {
  field: 'serviceNodeName',
  name: _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticResults.table.serviceNode', {
    defaultMessage: 'Service Node'
  }),
  render: value => value || /*#__PURE__*/_react.default.createElement("em", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 53
    }
  }, "\u2014")
}, {
  field: 'traceId',
  name: _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticResults.table.traceId', {
    defaultMessage: 'Trace ID'
  }),
  render: value => value || /*#__PURE__*/_react.default.createElement("em", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 53
    }
  }, "\u2014")
}];
function HighlightedExitSpansTable({
  items,
  title
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: items,
    columns: columns,
    tableLayout: "auto",
    "data-test-subj": "apmServiceMapHighlightedExitSpansTable",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }));
}