"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MobileCrashesOverview = MobileCrashesOverview;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _uuid = require("uuid");
var _use_time_range = require("../../../../hooks/use_time_range");
var _use_crash_group_distribution_fetcher = require("../../../../hooks/use_crash_group_distribution_fetcher");
var _mobile_errors_and_crashes_treemap = require("../charts/mobile_errors_and_crashes_treemap");
var _crash_group_list = require("./crash_group_list");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _distribution = require("../errors_and_crashes_group_details/shared/distribution");
var _chart_pointer_event_context = require("../../../../context/chart_pointer_event/chart_pointer_event_context");
var _get_comparison_options = require("../../../shared/time_comparison/get_comparison_options");
var _get_kuery_with_mobile_filters = require("../../../../../common/utils/get_kuery_with_mobile_filters");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/mobile/errors_and_crashes_overview/crashes_overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const INITIAL_STATE_MAIN_STATISTICS = {
  mobileCrashGroupMainStatistics: [],
  requestId: undefined,
  currentPageGroupIds: []
};
const INITIAL_STATE_DETAILED_STATISTICS = {
  currentPeriod: {},
  previousPeriod: {}
};
function MobileCrashesOverview() {
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    query: {
      environment,
      kuery,
      sortField = 'occurrences',
      sortDirection = 'desc',
      rangeFrom,
      rangeTo,
      offset,
      comparisonEnabled,
      page = 0,
      pageSize = 25,
      device,
      osVersion,
      appVersion,
      netConnectionType
    }
  } = (0, _use_apm_params.useApmParams)('/mobile-services/{serviceName}/errors-and-crashes/');
  const kueryWithMobileFilters = (0, _get_kuery_with_mobile_filters.getKueryWithMobileFilters)({
    device,
    osVersion,
    appVersion,
    netConnectionType,
    kuery
  });
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    crashDistributionData,
    status
  } = (0, _use_crash_group_distribution_fetcher.useCrashGroupDistributionFetcher)({
    serviceName,
    groupId: undefined,
    environment,
    kuery: kueryWithMobileFilters
  });
  const {
    data: crashGroupListData = INITIAL_STATE_MAIN_STATISTICS,
    status: crashGroupListDataStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    const normalizedSortDirection = sortDirection === 'asc' ? 'asc' : 'desc';
    if (start && end) {
      return callApmApi('GET /internal/apm/mobile-services/{serviceName}/crashes/groups/main_statistics', {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery: kueryWithMobileFilters,
            start,
            end,
            sortField,
            sortDirection: normalizedSortDirection
          }
        }
      }).then(response => {
        const currentPageGroupIds = (0, _lodash.orderBy)(response.errorGroups, sortField, sortDirection).slice(page * pageSize, (page + 1) * pageSize).map(({
          groupId
        }) => groupId).sort();
        return {
          // Everytime the main statistics is refetched, updates the requestId making the comparison API to be refetched.
          requestId: (0, _uuid.v4)(),
          mobileCrashGroupMainStatistics: response.errorGroups,
          currentPageGroupIds
        };
      });
    }
  }, [environment, kueryWithMobileFilters, serviceName, start, end, sortField, sortDirection, page, pageSize]);
  const {
    requestId,
    mobileCrashGroupMainStatistics,
    currentPageGroupIds
  } = crashGroupListData;
  const {
    data: mobileCrashGroupDetailedStatistics = INITIAL_STATE_DETAILED_STATISTICS,
    status: mobileCrashGroupDetailedStatisticsStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (requestId && currentPageGroupIds.length && start && end) {
      return callApmApi('POST /internal/apm/mobile-services/{serviceName}/crashes/groups/detailed_statistics', {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery: kueryWithMobileFilters,
            start,
            end,
            numBuckets: 20,
            offset: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? offset : undefined
          },
          body: {
            groupIds: JSON.stringify(currentPageGroupIds)
          }
        }
      });
    }
  },
  // only fetches agg results when requestId changes

  // eslint-disable-next-line react-hooks/exhaustive-deps
  [requestId], {
    preservePreviousData: false
  });
  const kueryForTreemap = (0, _get_kuery_with_mobile_filters.getKueryWithMobileCrashFilter)({
    kuery: kueryWithMobileFilters,
    groupId: undefined
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_chart_pointer_event_context.ChartPointerEventContextProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_distribution.ErrorDistribution, {
    fetchStatus: status,
    distribution: crashDistributionData,
    height: 375,
    title: _i18n.i18n.translate('xpack.apm.serviceDetails.metrics.crashOccurrencesChart.title', {
      defaultMessage: 'Crash occurrences'
    }),
    tip: _i18n.i18n.translate('xpack.apm.serviceDetails.metrics.errorOccurrencesChart.tip', {
      defaultMessage: `Crash occurrence is measured in crashes per minute.`
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_mobile_errors_and_crashes_treemap.MobileErrorsAndCrashesTreemap, {
    serviceName: serviceName,
    kuery: kueryForTreemap,
    environment: environment,
    start: start,
    end: end,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.serviceDetails.metrics.crashes.title', {
    defaultMessage: 'Crashes'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_crash_group_list.MobileCrashGroupList, {
    mainStatistics: mobileCrashGroupMainStatistics,
    serviceName: serviceName,
    detailedStatisticsLoading: (0, _use_fetcher.isPending)(mobileCrashGroupDetailedStatisticsStatus),
    detailedStatistics: mobileCrashGroupDetailedStatistics,
    comparisonEnabled: comparisonEnabled,
    initialSortField: sortField,
    initialSortDirection: sortDirection,
    isLoading: crashGroupListDataStatus === _use_fetcher.FETCH_STATUS.LOADING,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 11
    }
  }))));
}