"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessFunctionNameLink = ServerlessFunctionNameLink;
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _react = _interopRequireDefault(require("react"));
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _style = require("../../../../utils/style");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/metrics/serverless_metrics/serverless_function_name_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StyledLink = (0, _styled.default)(_eui.EuiLink)`
  ${(0, _style.truncate)('100%')};
`;
function ServerlessFunctionNameLink({
  serverlessFunctionName,
  serverlessId
}) {
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    query
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/metrics');
  const {
    link
  } = (0, _use_apm_router.useApmRouter)();
  return /*#__PURE__*/_react.default.createElement(StyledLink, {
    href: link('/services/{serviceName}/metrics/{id}', {
      path: {
        serviceName,
        id: serverlessId
      },
      query
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, serverlessFunctionName);
}