"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformRuleTypesInternalResponse = void 0;
var _fp = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformRuleTypesInternalResponse = ruleTypes => {
  return ruleTypes.map(ruleType => {
    return {
      ...(ruleType.actionGroups ? {
        action_groups: ruleType.actionGroups
      } : {}),
      ...(ruleType.actionVariables ? {
        action_variables: ruleType.actionVariables
      } : {}),
      ...(ruleType.alerts ? {
        alerts: ruleType.alerts
      } : {}),
      authorized_consumers: ruleType.authorizedConsumers,
      auto_recover_alerts: ruleType.autoRecoverAlerts,
      category: ruleType.category,
      default_action_group_id: ruleType.defaultActionGroupId,
      ...(ruleType.defaultScheduleInterval ? {
        default_schedule_interval: ruleType.defaultScheduleInterval
      } : {}),
      ...((0, _fp.isBoolean)(ruleType.doesSetRecoveryContext) ? {
        does_set_recovery_context: ruleType.doesSetRecoveryContext
      } : {}),
      enabled_in_license: ruleType.enabledInLicense,
      has_alerts_mappings: ruleType.hasAlertsMappings,
      id: ruleType.id,
      is_internally_managed: Boolean(ruleType.internallyManaged),
      is_exportable: ruleType.isExportable,
      minimum_license_required: ruleType.minimumLicenseRequired,
      name: ruleType.name,
      producer: ruleType.producer,
      solution: ruleType.solution,
      recovery_action_group: ruleType.recoveryActionGroup,
      ...(ruleType.ruleTaskTimeout ? {
        rule_task_timeout: ruleType.ruleTaskTimeout
      } : {})
    };
  });
};
exports.transformRuleTypesInternalResponse = transformRuleTypesInternalResponse;