"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMaintenanceWindowRequestBodySchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _schedule = require("../../../../../schedule");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createMaintenanceWindowRequestBodySchema = exports.createMaintenanceWindowRequestBodySchema = _configSchema.schema.object({
  title: _configSchema.schema.string({
    meta: {
      description: 'The name of the maintenance window. While this name does not have to be unique, a distinctive name can help you identify a specific maintenance window.'
    }
  }),
  enabled: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'Whether the current maintenance window is enabled. Disabled maintenance windows do not suppress notifications.'
    },
    defaultValue: true
  })),
  schedule: _configSchema.schema.object({
    custom: _schedule.scheduleRequestSchemaV1
  }),
  scope: _configSchema.schema.maybe(_configSchema.schema.object({
    // as we introduce more scopes, alerting will eventually become alerting: schema.maybe(schema.object({...
    alerting: _configSchema.schema.object({
      query: _configSchema.schema.object({
        kql: _configSchema.schema.string({
          meta: {
            description: 'A filter written in Kibana Query Language (KQL). Only alerts matching this query will be supressed by the maintenance window.'
          }
        })
      })
    })
  }))
});