"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _react = _interopRequireWildcard(require("react"));
var _expression = require("./expression");
var _form = require("../form");
var _flex = require("../flex");
var _panel = require("../panel");
var _popover = require("../popover");
var _services = require("../../services");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ /// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />
describe('EuiExpression', function () {
  var BaseExpression = function BaseExpression() {
    var _useState = (0, _react.useState)({
        isOpen: false,
        value: 'count()'
      }),
      _useState2 = _slicedToArray(_useState, 2),
      example1 = _useState2[0],
      setExample1 = _useState2[1];
    var _useState3 = (0, _react.useState)({
        value: 100,
        description: 'Is above'
      }),
      _useState4 = _slicedToArray(_useState3, 2),
      example2 = _useState4[0],
      setExample2 = _useState4[1];
    var expressionPopoverId__1 = (0, _services.useGeneratedHtmlId)({
      prefix: 'expressionPopover',
      suffix: 'first'
    });
    var expressionPopoverId__2 = (0, _services.useGeneratedHtmlId)({
      prefix: 'expressionPopover',
      suffix: 'second'
    });
    var openExample1 = function openExample1() {
      setExample1(_objectSpread(_objectSpread({}, example1), {}, {
        isOpen: true
      }));
      setExample2(_objectSpread(_objectSpread({}, example2), {}, {
        isOpen: false
      }));
    };
    var closeExample1 = function closeExample1() {
      setExample1(_objectSpread(_objectSpread({}, example1), {}, {
        isOpen: false
      }));
    };
    var openExample2 = function openExample2() {
      setExample1(_objectSpread(_objectSpread({}, example1), {}, {
        isOpen: false
      }));
      setExample2(_objectSpread(_objectSpread({}, example2), {}, {
        isOpen: true
      }));
    };
    var closeExample2 = function closeExample2() {
      setExample2(_objectSpread(_objectSpread({}, example2), {}, {
        isOpen: false
      }));
    };
    var changeExample1 = function changeExample1(event) {
      setExample1(_objectSpread(_objectSpread({}, example1), {}, {
        value: event.target.value
      }));
    };
    var changeExample2Value = function changeExample2Value(e) {
      var sanitizedValue = parseInt(e.target.value, 10);
      setExample2(_objectSpread(_objectSpread({}, example2), {}, {
        value: isNaN(sanitizedValue) ? '' : sanitizedValue
      }));
    };
    var changeExample2Description = function changeExample2Description(event) {
      setExample2(_objectSpread(_objectSpread({}, example2), {}, {
        description: event.target.value
      }));
    };
    var renderPopover1 = function renderPopover1() {
      return (0, _react2.jsx)("div", {
        "data-test-subj": "cy-expression-popover-1"
      }, (0, _react2.jsx)(_popover.EuiPopoverTitle, null, "When"), (0, _react2.jsx)(_form.EuiSelect, {
        compressed: true,
        value: example1.value,
        onChange: changeExample1,
        options: [{
          value: 'count()',
          text: 'count()'
        }, {
          value: 'average()',
          text: 'average()'
        }, {
          value: 'sum()',
          text: 'sum()'
        }, {
          value: 'median()',
          text: 'median()'
        }, {
          value: 'min()',
          text: 'min()'
        }, {
          value: 'max()',
          text: 'max()'
        }]
      }));
    };
    var renderPopover2 = function renderPopover2() {
      return (0, _react2.jsx)("div", {
        "data-test-subj": "cy-expression-popover-2"
      }, (0, _react2.jsx)(_flex.EuiFlexGroup, {
        gutterSize: "s"
      }, (0, _react2.jsx)(_flex.EuiFlexItem, {
        grow: false,
        style: {
          width: 150
        }
      }, (0, _react2.jsx)(_form.EuiSelect, {
        compressed: true,
        value: example2.description,
        onChange: changeExample2Description,
        options: [{
          value: 'Is above',
          text: 'Is above'
        }, {
          value: 'Is below',
          text: 'Is below'
        }, {
          value: 'Is exactly',
          text: 'Is exactly'
        }]
      })), (0, _react2.jsx)(_flex.EuiFlexItem, {
        grow: false,
        style: {
          width: 100
        }
      }, (0, _react2.jsx)(_form.EuiFieldNumber, {
        compressed: true,
        value: example2.value,
        onChange: changeExample2Value
      }))));
    };
    return (0, _react2.jsx)(_panel.EuiPanel, null, (0, _react2.jsx)(_flex.EuiFlexGroup, {
      gutterSize: "s"
    }, (0, _react2.jsx)(_flex.EuiFlexItem, {
      grow: false
    }, (0, _react2.jsx)(_popover.EuiPopover, {
      id: expressionPopoverId__1,
      button: (0, _react2.jsx)(_expression.EuiExpression, {
        description: "when",
        value: example1.value,
        isActive: example1.isOpen,
        onClick: openExample1
      }),
      isOpen: example1.isOpen,
      closePopover: closeExample1,
      panelPaddingSize: "s",
      anchorPosition: "downLeft"
    }, renderPopover1())), (0, _react2.jsx)(_flex.EuiFlexItem, {
      grow: false
    }, (0, _react2.jsx)(_popover.EuiPopover, {
      id: expressionPopoverId__2,
      panelPaddingSize: "s",
      button: (0, _react2.jsx)(_expression.EuiExpression, {
        description: example2.description,
        value: example2.value,
        isActive: example2.isOpen,
        onClick: openExample2
      }),
      isOpen: example2.isOpen,
      closePopover: closeExample2,
      anchorPosition: "downLeft"
    }, renderPopover2()))));
  };
  beforeEach(function () {
    cy.viewport(1024, 768); // medium breakpoint
    cy.realMount((0, _react2.jsx)(BaseExpression, null));
  });
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations when count popover is open', function () {
      cy.get('button').contains(/When count\(\)/i).realClick();
      cy.get('div[data-test-subj="cy-expression-popover-1"]').should('exist');
      cy.checkAxe();
    });
    it('has zero violations when is above popover is open', function () {
      cy.get('button').contains(/Is above 100/i).realClick();
      cy.get('div[data-test-subj="cy-expression-popover-2"]').should('exist');
      cy.checkAxe();
    });
    it('has zero violations when first popover is interacted with by keyboard', function () {
      cy.get('button').contains(/When count\(\)/i).focus();
      cy.realPress('Enter');
      cy.get('div[data-test-subj="cy-expression-popover-1"]').should('exist');
      cy.realPress('Tab');
      cy.realPress(['a', 'v', 'g']);
      cy.realPress('Escape');
      cy.get('button').contains(/When average\(\)/i).should('have.focus');
      cy.checkAxe();
    });
    it('has zero violations when second popover is interacted with by keyboard', function () {
      cy.get('button').contains(/Is above 100/i).focus();
      cy.realPress('Enter');
      cy.get('div[data-test-subj="cy-expression-popover-2"]').should('exist');
      cy.realPress('Tab');
      cy.realPress(['I', 's', ' ', 'e']);
      cy.realPress('Tab');
      cy.repeatRealPress('Delete', 3);
      cy.realPress(['5', '0', '0']);
      cy.realPress('Escape');
      cy.get('button').contains(/Is exactly 500/i).should('have.focus');
      cy.checkAxe();
    });
  });
});