"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultSessionsFilter = exports.TEST_ID = exports.SessionsView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/session-view-plugin/public");
var _reactRedux = require("react-redux");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _use_add_bulk_to_timeline = require("../../../detections/components/alerts_table/timeline_actions/use_add_bulk_to_timeline");
var _events_viewer = require("../events_viewer");
var _default_headers = require("./default_headers");
var _renderers = require("../../../timelines/components/timeline/body/renderers");
var _default_cell_renderer = require("../../../timelines/components/timeline/cell_rendering/default_cell_renderer");
var i18n = _interopRequireWildcard(require("./translations"));
var _model = require("../../../sourcerer/store/model");
var _control_columns = require("../../../timelines/components/timeline/body/control_columns");
var _use_license = require("../../hooks/use_license");
var _default_model = require("../events_viewer/default_model");
var _cell_actions = require("../cell_actions");
var _use_experimental_features = require("../../hooks/use_experimental_features");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/sessions_viewer/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TEST_ID = exports.TEST_ID = 'security_solution:sessions_viewer:sessions_view';
const defaultSessionsFilter = exports.defaultSessionsFilter = {
  query: {
    bool: {
      filter: [{
        bool: {
          // show sessions table results by filtering events where event.action is fork, exec, or end
          should: [{
            term: {
              [_ruleDataUtils.EVENT_ACTION]: 'exec'
            }
          },
          // exec event.action is used by Endpoint and Cloud Defend
          {
            term: {
              [_ruleDataUtils.EVENT_ACTION]: 'executed'
            }
          },
          // executed event.action is used by auditbeat
          {
            term: {
              [_ruleDataUtils.EVENT_ACTION]: 'fork'
            }
          }, {
            term: {
              [_ruleDataUtils.EVENT_ACTION]: 'end'
            }
          }]
        }
      }, {
        bool: {
          filter: {
            exists: {
              field: _public.ENTRY_SESSION_ENTITY_ID_PROPERTY // to exclude any records which have no entry_leader.entity_id
            }
          }
        }
      }],
      must_not: [{
        term: {
          [_public.ENTRY_SESSION_ENTITY_ID_PROPERTY]: ''
        }
      }]
    }
  },
  meta: {
    alias: null,
    disabled: false,
    key: _public.ENTRY_SESSION_ENTITY_ID_PROPERTY,
    negate: false,
    params: {},
    type: 'string'
  }
};
const SessionsViewComponent = ({
  tableId,
  endDate,
  entityType = 'sessions',
  pageFilters,
  startDate,
  filterQuery,
  columns = _default_headers.sessionsHeaders,
  defaultColumns = _default_headers.sessionsHeaders
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const parsedFilterQuery = (0, _react.useMemo)(() => {
    if (filterQuery && filterQuery !== '') {
      return JSON.parse(filterQuery);
    }
    return {};
  }, [filterQuery]);
  const sessionsFilter = (0, _react.useMemo)(() => [{
    ...defaultSessionsFilter,
    query: {
      ...defaultSessionsFilter.query,
      bool: {
        ...defaultSessionsFilter.query.bool,
        filter: defaultSessionsFilter.query.bool.filter.concat(parsedFilterQuery)
      }
    }
  }, ...pageFilters], [pageFilters, parsedFilterQuery]);
  (0, _react.useEffect)(() => {
    dispatch(_securitysolutionDataTable.dataTableActions.initializeDataTableSettings({
      id: tableId,
      title: i18n.SESSIONS_TITLE,
      defaultColumns: _default_model.eventsDefaultModel.columns,
      showCheckboxes: true,
      selectAll: true
    }));
  }, [dispatch, tableId]);
  const isEnterprisePlus = (0, _use_license.useLicense)().isEnterprise();
  const securitySolutionNotesDisabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('securitySolutionNotesDisabled');
  let ACTION_BUTTON_COUNT = isEnterprisePlus || tableId === _securitysolutionDataTable.TableId.kubernetesPageSessions ? 6 : 5;
  if (securitySolutionNotesDisabled) {
    ACTION_BUTTON_COUNT--;
  }
  const leadingControlColumns = (0, _react.useMemo)(() => (0, _control_columns.getDefaultControlColumn)(ACTION_BUTTON_COUNT), [ACTION_BUTTON_COUNT]);
  const addBulkToTimelineAction = (0, _use_add_bulk_to_timeline.useAddBulkToTimelineAction)({
    localFilters: sessionsFilter,
    tableId,
    from: startDate,
    to: endDate,
    scopeId: _model.SourcererScopeName.default
  });
  const bulkActions = (0, _react.useMemo)(() => {
    return {
      alertStatusActions: false,
      customBulkActions: [addBulkToTimelineAction]
    };
  }, [addBulkToTimelineAction]);
  const unit = c => c > 1 ? i18n.TOTAL_COUNT_OF_SESSIONS : i18n.SINGLE_COUNT_OF_SESSIONS;
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_events_viewer.StatefulEventsViewer, {
    cellActionsTriggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
    pageFilters: sessionsFilter,
    defaultModel: (0, _default_headers.getSessionsDefaultModel)(columns, defaultColumns),
    end: endDate,
    bulkActions: bulkActions,
    entityType: entityType,
    tableId: tableId,
    leadingControlColumns: leadingControlColumns,
    renderCellValue: _default_cell_renderer.DefaultCellRenderer,
    rowRenderers: _renderers.defaultRowRenderers,
    sourcererScope: _model.SourcererScopeName.default,
    start: startDate,
    unit: unit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 7
    }
  }));
};
SessionsViewComponent.displayName = 'SessionsViewComponent';
const SessionsView = exports.SessionsView = /*#__PURE__*/_react.default.memo(SessionsViewComponent);