"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupsFilterPopoverComponent = exports.GroupsFilterPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _toggle_selected_group = require("./toggle_selected_group");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/ml_popover/jobs_table/filters/groups_filter_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Popover for selecting which SecurityJob groups to filter on. Component extracts unique groups and
 * their counts from the provided SecurityJobs. The 'siem' & 'security' groups are filtered out as all jobs will be
 * siem/security jobs
 *
 * @param securityJobs jobs to fetch groups from to display for filtering
 * @param onSelectedGroupsChanged change listener to be notified when group selection changes
 */
const GroupsFilterPopoverComponent = ({
  securityJobs,
  onSelectedGroupsChanged
}) => {
  const [isGroupPopoverOpen, setIsGroupPopoverOpen] = (0, _react.useState)(false);
  const [selectedGroups, setSelectedGroups] = (0, _react.useState)([]);
  const groups = securityJobs.map(j => j.groups).flat().filter(g => g !== 'siem' && g !== 'security');
  const uniqueGroups = Array.from(new Set(groups));
  (0, _react.useEffect)(() => {
    onSelectedGroupsChanged(selectedGroups);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [selectedGroups.sort().join()]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      "data-test-subj": 'groups-filter-popover-button',
      iconType: "arrowDown",
      onClick: () => setIsGroupPopoverOpen(!isGroupPopoverOpen),
      isSelected: isGroupPopoverOpen,
      numFilters: uniqueGroups.length,
      hasActiveFilters: selectedGroups.length > 0,
      numActiveFilters: selectedGroups.length,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }, i18n.GROUPS),
    isOpen: isGroupPopoverOpen,
    closePopover: () => setIsGroupPopoverOpen(!isGroupPopoverOpen),
    panelPaddingSize: "none",
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, uniqueGroups.map((group, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
    checked: selectedGroups.includes(group) ? 'on' : undefined,
    key: `${index}-${group}`,
    onClick: () => (0, _toggle_selected_group.toggleSelectedGroup)(group, selectedGroups, setSelectedGroups),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, `${group} (${groups.filter(g => g === group).length})`)), uniqueGroups.length === 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    justifyContent: "spaceAround",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "minusInCircle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 13
    }
  }, i18n.NO_GROUPS_AVAILABLE))));
};
exports.GroupsFilterPopoverComponent = GroupsFilterPopoverComponent;
GroupsFilterPopoverComponent.displayName = 'GroupsFilterPopoverComponent';
const GroupsFilterPopover = exports.GroupsFilterPopover = /*#__PURE__*/_react.default.memo(GroupsFilterPopoverComponent);
GroupsFilterPopover.displayName = 'GroupsFilterPopover';