"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CallOut = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _utility_types = require("../../../../common/utility_types");
var _callout_dismiss_button = require("./callout_dismiss_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/callouts/callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CallOutComponent = ({
  message,
  iconType,
  dismissButtonText,
  onDismiss,
  showDismissButton = true
}) => {
  const {
    type,
    id,
    title,
    description
  } = message;
  const finalIconType = iconType !== null && iconType !== void 0 ? iconType : getDefaultIconType(type);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: type,
    title: title,
    iconType: finalIconType,
    "data-test-subj": `callout-${id}`,
    "data-test-messages": `[${id}]`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, description, showDismissButton && /*#__PURE__*/_react.default.createElement(_callout_dismiss_button.CallOutDismissButton, {
    message: message,
    text: dismissButtonText,
    onClick: onDismiss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }));
};
const getDefaultIconType = type => {
  switch (type) {
    case 'primary':
      return 'info';
    case 'success':
      return 'cheer';
    case 'warning':
      return 'help';
    case 'danger':
      return 'warning';
    case 'accent':
      return 'cheer';
    default:
      return (0, _utility_types.assertUnreachable)(type);
  }
};
const CallOut = exports.CallOut = /*#__PURE__*/(0, _react.memo)(CallOutComponent);