"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SKELETON_TEST_ID = exports.ERROR_TEST_ID = exports.CONTENT_TEST_ID = exports.AiForSOCAlertsTable = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_create_data_view = require("../../../detections/hooks/alert_summary/use_create_data_view");
var _use_fetch_integrations = require("../../../detections/hooks/alert_summary/use_fetch_integrations");
var _table = require("./table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/cases/components/ai_for_soc/wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DATAVIEW_ERROR = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.aiForSocTableTab.dataViewError', {
  defaultMessage: 'Unable to create data view'
});
const ERROR_TEST_ID = exports.ERROR_TEST_ID = 'cases-alert-error';
const SKELETON_TEST_ID = exports.SKELETON_TEST_ID = 'cases-alert-skeleton';
const CONTENT_TEST_ID = exports.CONTENT_TEST_ID = 'cases-alert-content';
/**
 * Component used in the Cases page under the Alerts tab, only in the AI4DSOC tier.
 * It fetches packages (integrations) and creates a local dataView.
 * It renders a loading skeleton while packages are being fetched and while the dataView is being created.
 */
const AiForSOCAlertsTable = exports.AiForSOCAlertsTable = /*#__PURE__*/(0, _react.memo)(({
  id,
  onLoaded,
  query
}) => {
  const {
    dataView,
    loading: dataViewLoading
  } = (0, _use_create_data_view.useCreateEaseAlertsDataView)();
  const {
    installedPackages,
    isLoading: integrationIsLoading
  } = (0, _use_fetch_integrations.useFetchIntegrations)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    "data-test-subj": SKELETON_TEST_ID,
    height: 400,
    isLoading: integrationIsLoading || dataViewLoading,
    width: "100%",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !dataView ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    color: "danger",
    "data-test-subj": ERROR_TEST_ID,
    iconType: "error",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 20
      }
    }, DATAVIEW_ERROR),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": CONTENT_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_table.Table, {
    dataView: dataView,
    id: id,
    onLoaded: onLoaded,
    packages: installedPackages,
    query: query,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 13
    }
  }))));
});
AiForSOCAlertsTable.displayName = 'AiForSOCAlertsTable';