"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvalidateFindAttackDiscoveries = exports.useFindAttackDiscoveries = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _reactQuery = require("@tanstack/react-query");
var _react = require("react");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_kibana_feature_flags = require("../use_kibana_feature_flags");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_PAGE = 1; // CAUTION: server-side API uses a 1-based page index convention (for consistency with similar existing APIs)
const DEFAULT_PER_PAGE = 10;
const useFindAttackDiscoveries = ({
  alertIds,
  ids,
  connectorNames,
  http,
  includeUniqueAlertIds = false,
  isAssistantEnabled,
  end,
  search,
  page = DEFAULT_PAGE,
  perPage = DEFAULT_PER_PAGE,
  refetchOnWindowFocus = false,
  shared,
  start,
  status,
  sortField = '@timestamp',
  sortOrder = 'desc'
}) => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    attackDiscoveryPublicApiEnabled
  } = (0, _use_kibana_feature_flags.useKibanaFeatureFlags)();
  const abortController = (0, _react.useRef)(new AbortController());
  const cancelRequest = (0, _react.useCallback)(() => {
    abortController.current.abort();
    abortController.current = new AbortController(); // LOCAL MUTATION
  }, []);
  const route = attackDiscoveryPublicApiEnabled ? _elasticAssistantCommon.ATTACK_DISCOVERY_FIND : _elasticAssistantCommon.ATTACK_DISCOVERY_INTERNAL_FIND;
  const version = attackDiscoveryPublicApiEnabled ? _elasticAssistantCommon.API_VERSIONS.public.v1 : _elasticAssistantCommon.API_VERSIONS.internal.v1;
  const queryFn = (0, _react.useCallback)(async ({
    pageParam
  }) => {
    var _pageParam$page, _pageParam$perPage;
    const baseQuery = {
      alert_ids: alertIds,
      connector_names: connectorNames,
      end,
      include_unique_alert_ids: includeUniqueAlertIds,
      ids,
      page: (_pageParam$page = pageParam === null || pageParam === void 0 ? void 0 : pageParam.page) !== null && _pageParam$page !== void 0 ? _pageParam$page : page,
      per_page: (_pageParam$perPage = pageParam === null || pageParam === void 0 ? void 0 : pageParam.perPage) !== null && _pageParam$perPage !== void 0 ? _pageParam$perPage : perPage,
      search,
      shared,
      sort_field: sortField,
      sort_order: sortOrder,
      start,
      status
    };
    if (attackDiscoveryPublicApiEnabled) {
      return http.fetch(route, {
        method: 'GET',
        version,
        query: {
          ...baseQuery,
          enable_field_rendering: true,
          // always true to enable rendering fields using the `{{ user.name james }}` syntax
          with_replacements: false // always false because Attack discoveries rendered in Kibana may be passed as context to a conversation, and to enable the user to see the original alert details via the `Show anonymized values` toggle
        },
        signal: abortController.current.signal
      });
    }
    return http.fetch(route, {
      method: 'GET',
      version,
      query: baseQuery,
      signal: abortController.current.signal
    });
  }, [alertIds, attackDiscoveryPublicApiEnabled, connectorNames, end, http, ids, includeUniqueAlertIds, page, perPage, route, search, shared, sortField, sortOrder, start, status, version]);
  const getNextPageParam = (0, _react.useCallback)(lastPage => {
    var _lastPage$per_page;
    const totalPages = Math.max(DEFAULT_PAGE, Math.ceil(lastPage.total / ((_lastPage$per_page = lastPage.per_page) !== null && _lastPage$per_page !== void 0 ? _lastPage$per_page : DEFAULT_PER_PAGE)));
    if (totalPages === lastPage.page) {
      return;
    }
    return {
      ...lastPage,
      page: lastPage.page + 1
    };
  }, []);
  const {
    data,
    error,
    isLoading,
    refetch,
    status: queryStatus
  } = (0, _reactQuery.useQuery)(['GET', route, alertIds, connectorNames, end, ids, page, perPage, search, shared, sortField, sortOrder, start, status, isAssistantEnabled], queryFn, {
    enabled: isAssistantEnabled,
    getNextPageParam,
    // Transform the API response's data items into UI-friendly alerts
    // only when the public API is enabled. Otherwise return the raw
    // response shape (internal API uses different field names).
    select: response => {
      if (attackDiscoveryPublicApiEnabled) {
        var _data;
        return {
          connector_names: response.connector_names,
          data: ((_data = response.data) !== null && _data !== void 0 ? _data : []).map(_elasticAssistantCommon.transformAttackDiscoveryAlertFromApi // transform each alert from snake_case to camelCase
          ),
          page: response.page,
          per_page: response.per_page,
          total: response.total,
          unique_alert_ids_count: response.unique_alert_ids_count,
          unique_alert_ids: response.unique_alert_ids
        };
      }
      return response;
    },
    onError: e => {
      addError(e.body && e.body.message ? new Error(e.body.message) : e, {
        title: i18n.ERROR_FINDING_ATTACK_DISCOVERIES
      });
    },
    refetchOnWindowFocus
  });
  return {
    cancelRequest,
    data,
    error,
    isLoading,
    refetch,
    status: queryStatus
  };
};

/**
 * We use this hook to invalidate the attack discovery generations cache.
 *
 * @returns A attack discovery schedule cache invalidation callback
 */
exports.useFindAttackDiscoveries = useFindAttackDiscoveries;
const useInvalidateFindAttackDiscoveries = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    attackDiscoveryPublicApiEnabled
  } = (0, _use_kibana_feature_flags.useKibanaFeatureFlags)();
  const route = attackDiscoveryPublicApiEnabled ? _elasticAssistantCommon.ATTACK_DISCOVERY_FIND : _elasticAssistantCommon.ATTACK_DISCOVERY_INTERNAL_FIND;
  return (0, _react.useCallback)(() => {
    queryClient.invalidateQueries(['GET', route], {
      refetchType: 'all'
    });
  }, [queryClient, route]);
};
exports.useInvalidateFindAttackDiscoveries = useInvalidateFindAttackDiscoveries;