"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerUIActions = void 0;
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/discover-plugin/public");
var _filter = require("./filter");
var _add_to_timeline = require("./add_to_timeline");
var _show_top_n = require("./show_top_n");
var _copy_to_clipboard = require("./copy_to_clipboard");
var _toggle_column = require("./toggle_column");
var _toggle_asset_column = require("./toggle_asset_column");
var _constants = require("./constants");
var _telemetry = require("./telemetry");
var _register_discover_histogram_actions = require("./register_discover_histogram_actions");
var _filter_in = require("./filter/lens/filter_in");
var _filter_out = require("./filter/lens/filter_out");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerUIActions = async (store, history, coreSetup, services) => {
  registerLensEmbeddableActions(store, services);
  registerDiscoverCellActions(store, services);
  registerCellActions(store, history, services);
  // TODO: Remove discover histogram actions when timeline esql tab is extracted from discover
  await (0, _register_discover_histogram_actions.registerDiscoverHistogramActions)(store, history, coreSetup, services);
};
exports.registerUIActions = registerUIActions;
const registerLensEmbeddableActions = (store, services) => {
  const {
    uiActions
  } = services;
  const filterInLegendActions = (0, _filter_in.createFilterInLensAction)({
    store,
    order: 2,
    services
  });
  uiActions.addTriggerAction(_public.CELL_VALUE_TRIGGER, filterInLegendActions);
  const filterOutLegendActions = (0, _filter_out.createFilterOutLensAction)({
    store,
    order: 3,
    services
  });
  uiActions.addTriggerAction(_public.CELL_VALUE_TRIGGER, filterOutLegendActions);
  const addToTimelineAction = (0, _add_to_timeline.createAddToTimelineLensAction)({
    store,
    order: 4
  });
  uiActions.addTriggerAction(_public.CELL_VALUE_TRIGGER, addToTimelineAction);
  const copyToClipboardAction = (0, _copy_to_clipboard.createCopyToClipboardLensAction)({
    order: 5
  });
  uiActions.addTriggerAction(_public.CELL_VALUE_TRIGGER, copyToClipboardAction);
};
const registerDiscoverCellActions = (store, services) => {
  const {
    uiActions
  } = services;
  const DiscoverCellActionsFactories = {
    filterIn: (0, _filter.createFilterInDiscoverCellActionFactory)({
      store,
      services
    }),
    filterOut: (0, _filter.createFilterOutDiscoverCellActionFactory)({
      store,
      services
    }),
    addToTimeline: (0, _add_to_timeline.createAddToTimelineDiscoverCellActionFactory)({
      store,
      services
    }),
    copyToClipboard: (0, _copy_to_clipboard.createCopyToClipboardDiscoverCellActionFactory)({
      services
    })
  };
  const addDiscoverEmbeddableCellActions = (triggerId, actionsOrder) => {
    actionsOrder.forEach((actionName, order) => {
      const actionFactory = DiscoverCellActionsFactories[actionName];
      if (actionFactory) {
        const action = actionFactory({
          id: `${triggerId}-${actionName}`,
          order
        });
        const actionWithTelemetry = (0, _telemetry.enhanceActionWithTelemetry)(action, services);
        uiActions.addTriggerAction(triggerId, actionWithTelemetry);
      }
    });
  };

  // this trigger is already registered by discover search embeddable
  addDiscoverEmbeddableCellActions(_public2.SEARCH_EMBEDDABLE_CELL_ACTIONS_TRIGGER_ID, ['filterIn', 'filterOut', 'addToTimeline', 'copyToClipboard']);
};
const registerCellActions = (store, _history, services) => {
  const {
    uiActions
  } = services;
  const cellActionsFactories = {
    filterIn: (0, _filter.createFilterInCellActionFactory)({
      store,
      services
    }),
    filterOut: (0, _filter.createFilterOutCellActionFactory)({
      store,
      services
    }),
    addToTimeline: (0, _add_to_timeline.createAddToTimelineCellActionFactory)({
      store,
      services
    }),
    investigateInNewTimeline: (0, _add_to_timeline.createInvestigateInNewTimelineCellActionFactory)({
      store,
      services
    }),
    showTopN: (0, _show_top_n.createShowTopNCellActionFactory)({
      services
    }),
    copyToClipboard: (0, _copy_to_clipboard.createCopyToClipboardCellActionFactory)({
      services
    }),
    toggleColumn: (0, _toggle_column.createToggleColumnCellActionFactory)({
      store,
      services
    }),
    toggleUserAssetField: (0, _toggle_asset_column.createToggleUserAssetFieldCellActionFactory)({
      store
    })
  };
  const registerCellActionsTrigger = (triggerId, actionsOrder) => {
    uiActions.registerTrigger({
      id: triggerId
    });
    actionsOrder.forEach((actionName, order) => {
      const actionFactory = cellActionsFactories[actionName];
      if (actionFactory) {
        const action = actionFactory({
          id: `${triggerId}-${actionName}`,
          order
        });
        const actionWithTelemetry = (0, _telemetry.enhanceActionWithTelemetry)(action, services);
        uiActions.addTriggerAction(triggerId, actionWithTelemetry);
      }
    });
  };
  registerCellActionsTrigger(_constants.SecurityCellActionsTrigger.DEFAULT, ['filterIn', 'filterOut', 'addToTimeline', 'showTopN', 'copyToClipboard']);
  registerCellActionsTrigger(_constants.SecurityCellActionsTrigger.DETAILS_FLYOUT, ['filterIn', 'filterOut', 'addToTimeline', 'toggleColumn', 'toggleUserAssetField', 'showTopN', 'copyToClipboard']);
  registerCellActionsTrigger(_constants.SecurityCellActionsTrigger.ALERTS_COUNT, ['investigateInNewTimeline']);
  registerCellActionsTrigger(_constants.SecurityCellActionsTrigger.CASE_EVENTS, ['addToTimeline', 'copyToClipboard']);
};