"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateUpdateRuleProps = void 0;
var _threshold = require("../../../../../utils/request_validation/threshold");
var _indicator_match = require("../../../../../utils/request_validation/indicator_match");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Additional validation that is implemented outside of the schema itself.
 */
const validateUpdateRuleProps = props => {
  return [...validateId(props), ...validateTimelineId(props), ...validateTimelineTitle(props), ...validateThreshold(props), ...(0, _indicator_match.validateThreatMapping)(props)];
};
exports.validateUpdateRuleProps = validateUpdateRuleProps;
const validateId = props => {
  if (props.id != null && props.rule_id != null) {
    return ['both "id" and "rule_id" cannot exist, choose one or the other'];
  } else if (props.id == null && props.rule_id == null) {
    return ['either "id" or "rule_id" must be set'];
  } else {
    return [];
  }
};
const validateTimelineId = props => {
  if (props.timeline_id != null) {
    if (props.timeline_title == null) {
      return ['when "timeline_id" exists, "timeline_title" must also exist'];
    } else if (props.timeline_id === '') {
      return ['"timeline_id" cannot be an empty string'];
    } else {
      return [];
    }
  }
  return [];
};
const validateTimelineTitle = props => {
  if (props.timeline_title != null) {
    if (props.timeline_id == null) {
      return ['when "timeline_title" exists, "timeline_id" must also exist'];
    } else if (props.timeline_title === '') {
      return ['"timeline_title" cannot be an empty string'];
    } else {
      return [];
    }
  }
  return [];
};
const validateThreshold = props => (0, _threshold.validateThresholdBase)(props);