"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityNavControl = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _userProfileComponents = require("@kbn/user-profile-components");
var _model = require("../../common/model");
var _components = require("../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/nav_control/nav_control_component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ContextMenuContent = ({
  items,
  closePopover
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }, items.map((item, i) => {
    if (item.content) {
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        key: i,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 47,
          columnNumber: 15
        }
      }, typeof item.content === 'function' ? item.content({
        closePopover
      }) : item.content);
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: i,
      icon: item.icon,
      size: "s",
      href: item.href,
      "data-test-subj": item['data-test-subj'],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 13
      }
    }, item.name);
  })));
};
const SecurityNavControl = ({
  editProfileUrl,
  logoutUrl,
  userMenuLinks$
}) => {
  const userMenuLinks = (0, _useObservable.default)(userMenuLinks$, []);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const userProfile = (0, _components.useUserProfile)('avatar,userSettings');
  const currentUser = (0, _components.useCurrentUser)(); // User profiles do not exist for anonymous users so need to fetch current user as well

  const displayName = currentUser.value ? (0, _model.getUserDisplayName)(currentUser.value) : '';
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItemButton, {
    "aria-controls": "headerUserMenu",
    "aria-expanded": isPopoverOpen,
    "aria-haspopup": "true",
    "aria-label": _i18n.i18n.translate('xpack.security.navControlComponent.accountMenuAriaLabel', {
      defaultMessage: 'Account menu'
    }),
    onClick: () => setIsPopoverOpen(value => currentUser.value ? !value : false),
    "data-test-subj": "userMenuButton",
    style: {
      lineHeight: 'normal'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  }, userProfile.value ? /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserAvatar, {
    user: userProfile.value.user,
    avatar: userProfile.value.data.avatar,
    size: "s",
    "data-test-subj": "userMenuAvatar",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }) : currentUser.value && userProfile.error ? /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserAvatar, {
    user: currentUser.value,
    size: "s",
    "data-test-subj": "userMenuAvatar",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }));
  const items = [];
  if (userMenuLinks.length) {
    const userMenuLinkMenuItems = userMenuLinks.sort(({
      order: orderA = Infinity
    }, {
      order: orderB = Infinity
    }) => orderA - orderB).map(({
      label,
      iconType,
      href,
      content
    }) => ({
      name: label,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: iconType,
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 15
        }
      }),
      href,
      'data-test-subj': `userMenuLink__${label}`,
      content
    }));
    items.push(...userMenuLinkMenuItems);
  }
  const isAnonymous = currentUser.value ? (0, _model.isUserAnonymous)(currentUser.value) : false;
  const hasCustomProfileLinks = userMenuLinks.some(({
    setAsProfile
  }) => setAsProfile === true);
  if (!isAnonymous && !hasCustomProfileLinks) {
    const profileMenuItem = {
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.navControlComponent.editProfileLinkText",
        defaultMessage: "Edit profile",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 135,
          columnNumber: 9
        }
      }),
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "user",
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 140,
          columnNumber: 13
        }
      }),
      href: editProfileUrl,
      onClick: () => {
        setIsPopoverOpen(false);
      },
      'data-test-subj': 'profileLink'
    };

    // Set this as the first link if there is no user-defined profile link
    items.unshift(profileMenuItem);
  }
  items.push({
    name: isAnonymous ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.navControlComponent.loginLinkText",
      defaultMessage: "Log in",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 7
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.navControlComponent.logoutLinkText",
      defaultMessage: "Log out",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 7
      }
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "exit",
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 11
      }
    }),
    href: logoutUrl,
    'data-test-subj': 'logoutLink'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "headerUserMenu",
    ownFocus: true,
    button: button,
    isOpen: isPopoverOpen,
    anchorPosition: "downRight",
    repositionOnScroll: true,
    closePopover: () => setIsPopoverOpen(false),
    panelPaddingSize: "none",
    buffer: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    className: "chrNavControl__userMenu",
    initialPanelId: 0,
    panels: [{
      id: 0,
      title: displayName,
      content: /*#__PURE__*/_react.default.createElement(ContextMenuContent, {
        items: items,
        closePopover: () => setIsPopoverOpen(false),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 189,
          columnNumber: 15
        }
      })
    }],
    "data-test-subj": "userMenu",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 7
    }
  }));
};
exports.SecurityNavControl = SecurityNavControl;