"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmDeleteUsers = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _useAsyncFn = _interopRequireDefault(require("react-use/lib/useAsyncFn"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _ = require("..");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/users/edit_user/confirm_delete_users.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConfirmDeleteUsers = ({
  usernames,
  onCancel,
  onSuccess
}) => {
  const {
    services
  } = (0, _public.useKibana)();
  const [state, deleteUsers] = (0, _useAsyncFn.default)(async () => {
    for (const username of usernames) {
      try {
        await new _.UserAPIClient(services.http).deleteUser(username);
        services.notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.security.management.users.confirmDeleteUsers.successMessage', {
          defaultMessage: "Deleted user ''{username}''",
          values: {
            username
          }
        }));
        onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess();
      } catch (error) {
        var _body;
        services.notifications.toasts.addDanger({
          title: _i18n.i18n.translate('xpack.security.management.users.confirmDeleteUsers.errorMessage', {
            defaultMessage: "Could not delete user ''{username}''",
            values: {
              username
            }
          }),
          text: ((_body = error.body) === null || _body === void 0 ? void 0 : _body.message) || error.message
        });
      }
    }
  }, [services.http]);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    role: "dialog",
    title: _i18n.i18n.translate('xpack.security.management.users.confirmDeleteUsers.title', {
      defaultMessage: "Delete {count, plural, one{user ''{username}''} other{{count} users}}?",
      values: {
        count: usernames.length,
        username: usernames[0]
      }
    }),
    onCancel: onCancel,
    onConfirm: deleteUsers,
    cancelButtonText: _i18n.i18n.translate('xpack.security.management.users.confirmDeleteUsers.cancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.security.management.users.confirmDeleteUsers.confirmButton', {
      defaultMessage: '{isLoading, select, true{Deleting {count, plural, one{user} other{users}}…} other{Delete {count, plural, one{user} other{users}}}}',
      values: {
        count: usernames.length,
        isLoading: state.loading
      }
    }),
    buttonColor: "danger",
    isLoading: state.loading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.confirmDeleteUsers.description",
    defaultMessage: "{count, plural, one{This user} other{These users}} will be permanently deleted and access to Elastic removed{count, plural, one{.} other{:}}",
    values: {
      count: usernames.length
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  })), usernames.length > 1 && /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }, usernames.map(username => /*#__PURE__*/_react.default.createElement("li", {
    key: username,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 15
    }
  }, username))), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.confirmDelete.cannotUndoWarning",
    defaultMessage: "You can't recover deleted users.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }))));
};
exports.ConfirmDeleteUsers = ConfirmDeleteUsers;