"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HighlightDetailsTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _lib = require("../../lib");
var _percentage_badge = require("../percentage_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/searchprofiler/public/application/components/highlight_details_flyout/highlight_details_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const HighlightDetailsTable = ({
  breakdown
}) => {
  const columns = [{
    name: 'Description',
    render: item => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "left",
      content: item.tip,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 24,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 25,
        columnNumber: 11
      }
    }, item.key))
  }, {
    name: 'Time',
    render: item => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: item.color,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 11
      }
    }, item.key.endsWith('_count') ? item.time : (0, _lib.nsToPretty)(item.time, 1)))
  }, {
    name: 'Percentage',
    render: item => /*#__PURE__*/_react.default.createElement(_percentage_badge.PercentageBadge, {
      timePercentage: String(item.relative),
      label: item.relative + '%',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 9
      }
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: breakdown,
    columns: columns,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 10
    }
  });
};
exports.HighlightDetailsTable = HighlightDetailsTable;