"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchIndexDetailsSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_indices/public/components/indices/details_page_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SearchIndexDetailsSettings = ({
  indexName,
  userPrivileges
}) => {
  const {
    indexManagement,
    history
  } = (0, _use_kibana.useKibana)().services;
  const hasUpdateSettingsPrivilege = (0, _react.useMemo)(() => {
    return (userPrivileges === null || userPrivileges === void 0 ? void 0 : userPrivileges.privileges.canManageIndex) === true;
  }, [userPrivileges]);
  const IndexSettingsComponent = (0, _react.useMemo)(() => indexManagement.getIndexSettingsComponent({
    history
  }), [indexManagement, history]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(IndexSettingsComponent, {
    indexName: indexName,
    hasUpdateSettingsPrivilege: hasUpdateSettingsPrivilege,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }));
};
exports.SearchIndexDetailsSettings = SearchIndexDetailsSettings;