"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultFields = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _result_field = require("./result_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/packages/shared/kbn-search-index-documents/components/result/results_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ResultFields = ({
  documentId,
  fields,
  isExpanded
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
    "aria-label": _i18n.i18n.translate('xpack.searchIndexDocuments.resultFields.tableLabel', {
      defaultMessage: 'Fields for the document with ID {documentId}',
      values: {
        documentId
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
    width: "20%",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.searchIndexDocuments.resultFields.fieldTypeHeaderLabel', {
    defaultMessage: 'Field'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.searchIndexDocuments.resultFields.contentstableHeaderLabel', {
    defaultMessage: 'Contents'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }, fields.map(field => /*#__PURE__*/_react.default.createElement(_result_field.ResultField, {
    isExpanded: isExpanded,
    iconType: field.iconType,
    fieldName: field.fieldName,
    fieldValue: field.fieldValue,
    fieldType: field.fieldType,
    key: field.fieldName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 11
    }
  }))));
};
exports.ResultFields = ResultFields;