"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssignFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lib = require("./lib");
var _components = require("./components");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/saved_objects_tagging/public/components/assign_flyout/assign_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getObjectStatus = (object, assignedTags) => {
  const assignedCount = assignedTags.reduce((count, tagId) => {
    return count + (object.tags.includes(tagId) ? 1 : 0);
  }, 0);
  return assignedCount === 0 ? 'none' : assignedCount === assignedTags.length ? 'full' : 'partial';
};
const AssignFlyout = ({
  tagIds,
  tagCache,
  allowedTypes,
  notifications,
  assignmentService,
  onClose
}) => {
  const [results, setResults] = (0, _react.useState)([]);
  const [query, setQuery] = (0, _react.useState)(_eui.Query.parse(''));
  const [initialStatus, setInitialStatus] = (0, _react.useState)({});
  const [overrides, setOverrides] = (0, _react.useState)({});
  const [isLoading, setLoading] = (0, _react.useState)(false);
  const [isSaving, setSaving] = (0, _react.useState)(false);
  const [initiallyAssigned, setInitiallyAssigned] = (0, _react.useState)(0);
  const [pendingChangeCount, setPendingChangeCount] = (0, _react.useState)(0);

  // refresh the results when `query` is updated
  (0, _react.useEffect)(() => {
    const refreshResults = async () => {
      setLoading(true);
      const {
        queryText,
        selectedTypes
      } = (0, _lib.parseQuery)(query);
      const fetched = await assignmentService.findAssignableObjects({
        search: queryText ? `${queryText}*` : undefined,
        types: selectedTypes,
        maxResults: 1000
      });
      const fetchedStatus = fetched.reduce((status, result) => {
        return {
          ...status,
          [(0, _utils.getKey)(result)]: getObjectStatus(result, tagIds)
        };
      }, {});
      const assignedCount = Object.values(fetchedStatus).filter(status => status !== 'none').length;
      setResults((0, _utils.sortByStatusAndTitle)(fetched, fetchedStatus));
      setOverrides({});
      setInitialStatus(fetchedStatus);
      setInitiallyAssigned(assignedCount);
      setPendingChangeCount(0);
      setLoading(false);
    };
    refreshResults();
  }, [query, assignmentService, tagIds]);

  // refresh the pending changes count when `overrides` is update
  (0, _react.useEffect)(() => {
    const changes = (0, _lib.computeRequiredChanges)({
      objects: results,
      initialStatus,
      overrides
    });
    setPendingChangeCount(changes.assigned.length + changes.unassigned.length);
  }, [initialStatus, overrides, results]);
  const onSave = (0, _react.useCallback)(async () => {
    setSaving(true);
    const changes = (0, _lib.computeRequiredChanges)({
      objects: results,
      initialStatus,
      overrides
    });
    await assignmentService.updateTagAssignments({
      tags: tagIds,
      assign: changes.assigned.map(({
        type,
        id
      }) => ({
        type,
        id
      })),
      unassign: changes.unassigned.map(({
        type,
        id
      }) => ({
        type,
        id
      }))
    });
    notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.savedObjectsTagging.assignFlyout.successNotificationTitle', {
      defaultMessage: 'Saved assignments to {count, plural, one {1 saved object} other {# saved objects}}',
      values: {
        count: changes.assigned.length + changes.unassigned.length
      }
    }));
    onClose();
  }, [tagIds, results, initialStatus, overrides, notifications, assignmentService, onClose]);
  const resetAll = (0, _react.useCallback)(() => {
    setOverrides({});
  }, []);
  const selectAll = (0, _react.useCallback)(() => {
    setOverrides(results.reduce((status, result) => {
      return {
        ...status,
        [(0, _utils.getKey)(result)]: 'selected'
      };
    }, {}));
  }, [results]);
  const deselectAll = (0, _react.useCallback)(() => {
    setOverrides(results.reduce((status, result) => {
      return {
        ...status,
        [(0, _utils.getKey)(result)]: 'deselected'
      };
    }, {}));
  }, [results]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_components.AssignFlyoutHeader, {
    tagIds: tagIds,
    tagCache: tagCache,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_components.AssignFlyoutSearchBar, {
    onChange: ({
      query: newQuery
    }) => {
      setQuery(newQuery);
    },
    isLoading: isLoading,
    types: allowedTypes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_components.AssignFlyoutActionBar, {
    resultCount: results.length,
    initiallyAssigned: initiallyAssigned,
    pendingChanges: pendingChangeCount,
    onReset: resetAll,
    onSelectAll: selectAll,
    onDeselectAll: deselectAll,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_components.AssignFlyoutResultList, {
    results: results,
    isLoading: isLoading,
    initialStatus: initialStatus,
    overrides: overrides,
    onChange: newOverrides => {
      setOverrides(oldOverrides => ({
        ...oldOverrides,
        ...newOverrides
      }));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_components.AssignFlyoutFooter, {
    isSaving: isSaving,
    hasPendingChanges: pendingChangeCount > 0,
    onSave: onSave,
    onCancel: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 9
    }
  })));
};
exports.AssignFlyout = AssignFlyout;