"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectsManagementPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _services = require("./services");
var _lib = require("./lib");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
// keeping the interface to reduce work if we want to add back APIs later
// eslint-disable-next-line @typescript-eslint/no-empty-interface

class SavedObjectsManagementPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "actionService", new _services.SavedObjectsManagementActionService());
    (0, _defineProperty2.default)(this, "columnService", new _services.SavedObjectsManagementColumnService());
    (0, _defineProperty2.default)(this, "actionServiceStart", void 0);
    (0, _defineProperty2.default)(this, "columnServiceStart", void 0);
  }
  setup(core, {
    home,
    management
  }) {
    const actionSetup = this.actionService.setup();
    const columnSetup = this.columnService.setup();
    if (home) {
      home.featureCatalogue.register({
        id: 'saved_objects',
        title: _i18n.i18n.translate('savedObjectsManagement.objects.savedObjectsTitle', {
          defaultMessage: 'Saved Objects'
        }),
        description: _i18n.i18n.translate('savedObjectsManagement.objects.savedObjectsDescription', {
          defaultMessage: 'Import, export, and manage your saved objects.'
        }),
        icon: 'savedObjectsApp',
        path: '/app/management/kibana/objects',
        showOnHomePage: false,
        category: 'admin'
      });
    }
    const kibanaSection = management.sections.section.kibana;
    kibanaSection.registerApp({
      id: 'objects',
      title: _i18n.i18n.translate('savedObjectsManagement.managementSectionLabel', {
        defaultMessage: 'Saved Objects'
      }),
      order: 1,
      mount: async mountParams => {
        const {
          mountManagementSection
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./management_section')));
        return mountManagementSection({
          core,
          mountParams,
          getColumnServiceStart: () => this.columnServiceStart,
          getActionServiceStart: () => this.actionServiceStart
        });
      }
    });
    return {
      actions: actionSetup,
      columns: columnSetup
    };
  }
  start(_core, {
    spaces: spacesApi
  }) {
    this.actionServiceStart = this.actionService.start(spacesApi);
    this.columnServiceStart = this.columnService.start(spacesApi);
    return {
      getAllowedTypes: () => (0, _lib.getAllowedTypes)(_core.http),
      getRelationships: (type, id, savedObjectTypes, size) => (0, _lib.getRelationships)(_core.http, type, id, savedObjectTypes, size),
      getSavedObjectLabel: _lib.getSavedObjectLabel,
      getDefaultTitle: _lib.getDefaultTitle,
      parseQuery: _lib.parseQuery,
      getTagFindReferences: _lib.getTagFindReferences
    };
  }
}
exports.SavedObjectsManagementPlugin = SavedObjectsManagementPlugin;