"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteConfirmModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _lib = require("../../../lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/saved_objects_management/public/management_section/objects_table/components/delete_confirm_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DeleteConfirmModal = ({
  isDeleting,
  onConfirm,
  onCancel,
  selectedObjects,
  allowedTypes,
  showPlainSpinner
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const hiddenObjects = (0, _react.useMemo)(() => {
    return selectedObjects.filter(obj => obj.meta.hiddenType);
  }, [selectedObjects]);
  const deletableObjects = (0, _react.useMemo)(() => {
    return selectedObjects.filter(obj => !obj.meta.hiddenType).map(({
      type,
      id,
      meta,
      namespaces = []
    }) => {
      const {
        title = '',
        icon = 'apps'
      } = meta;
      const isShared = namespaces.length > 1 || namespaces.includes('*');
      return {
        type,
        id,
        icon,
        title,
        isShared
      };
    });
  }, [selectedObjects]);
  const sharedObjectsCount = (0, _react.useMemo)(() => {
    return deletableObjects.filter(obj => obj.isShared).length;
  }, [deletableObjects]);
  if (isDeleting) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiOverlayMask, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 7
      }
    }, showPlainSpinner ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 29
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingElastic, {
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 63
      }
    }));
  }
  // can't use `EuiConfirmModal` here as the confirm modal body is wrapped
  // inside a `<p>` element, causing UI glitches with the table.
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    initialFocus: "soDeleteConfirmModalConfirmBtn",
    onClose: onCancel,
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.deleteSavedObjectsConfirmModalTitle",
    defaultMessage: "Delete saved objects",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }, hiddenObjects.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "cannotDeleteObjectsConfirmWarning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "savedObjectsManagement.objectsTable.deleteConfirmModal.cannotDeleteCallout.title",
      defaultMessage: "Some objects have been excluded",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 17
      }
    }),
    iconType: "warning",
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 13
    }
  }, hiddenObjects.length > 0 && /*#__PURE__*/_react.default.createElement("p", {
    css: (0, _react2.css)`
                    margin-block-end: 0 !important;
                  `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.deleteConfirmModal.cannotDeleteCallout.content",
    defaultMessage: "{objectCount, plural, one {# object is} other {# objects are}} hidden and cannot be deleted.",
    values: {
      objectCount: hiddenObjects.length
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 13
    }
  })), sharedObjectsCount > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "sharedObjectsWarning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "savedObjectsManagement.objectsTable.deleteConfirmModal.sharedObjectsCallout.title",
      defaultMessage: "{sharedObjectsCount, plural, one {# saved object is shared} other {# of your saved objects are shared}}",
      values: {
        sharedObjectsCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 17
      }
    }),
    iconType: "warning",
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.deleteConfirmModal.sharedObjectsCallout.content",
    defaultMessage: "Shared objects are deleted from every space they are in.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.deleteSavedObjectsConfirmModalDescription",
    defaultMessage: "This action will delete the following saved objects:",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: deletableObjects,
    columns: [{
      field: 'type',
      name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.deleteSavedObjectsConfirmModal.typeColumnName', {
        defaultMessage: 'Type'
      }),
      width: '50px',
      render: (type, {
        icon
      }) => /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        position: "top",
        content: (0, _lib.getSavedObjectLabel)(type, allowedTypes),
        type: icon,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 168,
          columnNumber: 17
        }
      })
    }, {
      field: 'id',
      name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.deleteSavedObjectsConfirmModal.idColumnName', {
        defaultMessage: 'ID'
      })
    }, {
      field: 'title',
      name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.deleteSavedObjectsConfirmModal.titleColumnName', {
        defaultMessage: 'Title'
      })
    }],
    pagination: true,
    sorting: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    "data-test-subj": "confirmModalCancelButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.deleteSavedObjectsConfirmModal.cancelButtonLabel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    id: "soDeleteConfirmModalConfirmBtn",
    fill: true,
    color: "danger",
    onClick: onConfirm,
    disabled: deletableObjects.length === 0,
    "data-test-subj": "confirmModalConfirmButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.deleteSavedObjectsConfirmModal.deleteButtonLabel",
    defaultMessage: "Delete {objectsCount, plural, one {# object} other {# objects}}",
    values: {
      objectsCount: deletableObjects.length
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 19
    }
  }))))))));
};
exports.DeleteConfirmModal = DeleteConfirmModal;