"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "METRIC_TYPE", {
  enumerable: true,
  get: function () {
    return _analytics.METRIC_TYPE;
  }
});
exports.trackUserRequest = trackUserRequest;
var _analytics = require("@kbn/analytics");
var _kibana_services = require("../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Transparently return provided request Promise, while allowing us to track
 * a successful completion of the request.
 */
function trackUserRequest(request, actionType) {
  // Only track successful actions.
  return request.then(response => {
    // NOTE: METRIC_TYPE.LOADED is probably the wrong metric type here. The correct metric type
    // is more likely METRIC_TYPE.APPLICATION_USAGE. This change was introduced in
    // https://github.com/elastic/kibana/pull/41113/files#diff-58ac12bdd1a3a05a24e69ff20633c482R20
    (0, _kibana_services.trackUiMetric)(_analytics.METRIC_TYPE.LOADED, actionType);
    // We return the response immediately without waiting for the tracking request to resolve,
    // to avoid adding additional latency.
    return response;
  });
}