"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SCHEDULED_REPORT_SAVED_OBJECT_TYPE = void 0;
exports.setupSavedObjects = setupSavedObjects;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _scheduled_report = require("./scheduled_report");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SCHEDULED_REPORT_SAVED_OBJECT_TYPE = exports.SCHEDULED_REPORT_SAVED_OBJECT_TYPE = 'scheduled_report';
function setupSavedObjects(savedObjects) {
  savedObjects.registerType({
    name: SCHEDULED_REPORT_SAVED_OBJECT_TYPE,
    indexPattern: _coreSavedObjectsServer.ALERTING_CASES_SAVED_OBJECT_INDEX,
    hidden: true,
    namespaceType: 'multiple',
    mappings: _scheduled_report.scheduledReportMappings,
    management: {
      importableAndExportable: false
    },
    modelVersions: _scheduled_report.scheduledReportModelVersions
  });
}