"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ReportExportsTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _reportingCommon = require("@kbn/reporting-common");
var _reportingPublic = require("@kbn/reporting-public");
var _job_utils = require("../../../common/job_utils");
var _poller = require("../../../common/poller");
var _ = require(".");
var _utils = require("../utils");
var _translations = require("../../translations");
var _truncated_title = require("./truncated_title");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/reporting/public/management/components/report_exports_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class ReportExportsTable extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "isInitialJobsFetch", void 0);
    (0, _defineProperty2.default)(this, "licenseSubscription", void 0);
    (0, _defineProperty2.default)(this, "mounted", void 0);
    (0, _defineProperty2.default)(this, "poller", void 0);
    (0, _defineProperty2.default)(this, "licenseHandler", license => {
      const {
        enableLinks,
        showLinks,
        message: badLicenseMessage
      } = (0, _reportingPublic.checkLicense)(license.check('reporting', 'basic'));
      this.setState({
        enableLinks,
        showLinks,
        badLicenseMessage
      });
    });
    (0, _defineProperty2.default)(this, "onSelectionChange", jobs => {
      this.setState(current => ({
        ...current,
        selectedJobs: jobs
      }));
    });
    (0, _defineProperty2.default)(this, "removeJob", job => {
      const {
        jobs
      } = this.state;
      const filtered = jobs.filter(j => j.id !== job.id);
      this.setState(current => ({
        ...current,
        jobs: filtered
      }));
    });
    (0, _defineProperty2.default)(this, "renderDeleteButton", () => {
      const {
        selectedJobs
      } = this.state;
      if (selectedJobs.length === 0) return undefined;
      const performDelete = async () => {
        for (const job of selectedJobs) {
          try {
            await this.props.apiClient.deleteReport(job.id);
            this.removeJob(job);
            this.props.toasts.addSuccess(_i18n.i18n.translate('xpack.reporting.exports.table.deleteConfirm', {
              defaultMessage: `The {reportTitle} report was deleted`,
              values: {
                reportTitle: job.title
              }
            }));
          } catch (error) {
            this.props.toasts.addDanger(_i18n.i18n.translate('xpack.reporting.exports.table.deleteFailedErrorMessage', {
              defaultMessage: `The report was not deleted: {error}`,
              values: {
                error
              }
            }));
            throw error;
          }
        }
      };
      return /*#__PURE__*/_react.default.createElement(_.ReportDeleteButton, (0, _extends2.default)({
        jobsToDelete: selectedJobs,
        performDelete: performDelete
      }, this.props, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 156,
          columnNumber: 7
        }
      }));
    });
    (0, _defineProperty2.default)(this, "onTableChange", ({
      page
    }) => {
      const {
        index: pageIndex,
        size: perPage
      } = page;
      this.setState(() => ({
        page: pageIndex,
        perPage
      }), this.fetchJobs);
    });
    (0, _defineProperty2.default)(this, "fetchJobs", async () => {
      // avoid page flicker when poller is updating table - only display loading screen on first load
      if (this.isInitialJobsFetch) {
        this.setState(() => ({
          isLoading: true
        }));
      }
      let jobs;
      let total;
      try {
        jobs = await this.props.apiClient.list(this.state.page, this.state.perPage);
        total = await this.props.apiClient.total();
        this.isInitialJobsFetch = false;
      } catch (fetchError) {
        if (!this.licenseAllowsToShowThisPage()) {
          this.props.toasts.addDanger(this.state.badLicenseMessage);
          this.props.redirect('management');
          return;
        }
        if (fetchError.message === 'Failed to fetch') {
          this.props.toasts.addDanger(fetchError.message || _i18n.i18n.translate('xpack.reporting.exports.table.requestFailedErrorMessage', {
            defaultMessage: 'Request failed'
          }));
        }
        if (this.mounted) {
          this.setState(() => ({
            isLoading: false,
            jobs: [],
            total: 0
          }));
        }
        return;
      }
      if (this.mounted) {
        this.setState(() => ({
          isLoading: false,
          total,
          jobs
        }));
      }
    });
    (0, _defineProperty2.default)(this, "licenseAllowsToShowThisPage", () => {
      return this.state.showLinks && this.state.enableLinks;
    });
    /**
     * Widths like this are not the best, but the auto-layout does not play well with text in links. We can update
     * this with something that works better on all screen sizes. This works for desktop, mobile fallback is provided on a
     * per column basis.
     */
    (0, _defineProperty2.default)(this, "tableColumnWidths", {
      type: '5%',
      title: '25%',
      status: '20%',
      createdAt: '21%',
      content: '7%',
      exportType: '12%',
      actions: '10%'
    });
    this.state = {
      page: 0,
      perPage: 50,
      total: 0,
      jobs: [],
      selectedJobs: [],
      isLoading: false,
      showLinks: false,
      enableLinks: false,
      badLicenseMessage: '',
      selectedJob: undefined
    };
    this.isInitialJobsFetch = true;
  }
  componentWillUnmount() {
    var _this$poller;
    this.mounted = false;
    (_this$poller = this.poller) === null || _this$poller === void 0 ? void 0 : _this$poller.stop();
    if (this.licenseSubscription) {
      this.licenseSubscription.unsubscribe();
    }
  }
  componentDidMount() {
    this.mounted = true;
    const {
      config,
      license$
    } = this.props;
    const pollFrequencyInMillis = (0, _reportingCommon.durationToNumber)(config.poll.jobsRefresh.interval);
    this.poller = new _poller.Poller({
      functionToPoll: () => {
        return this.fetchJobs();
      },
      pollFrequencyInMillis,
      trailing: false,
      continuePollingOnError: true,
      pollFrequencyErrorMultiplier: config.poll.jobsRefresh.intervalErrorMultiplier
    });
    this.poller.start();
    this.licenseSubscription = license$.subscribe(this.licenseHandler);
  }
  render() {
    const {
      tableColumnWidths
    } = this;
    const tableColumns = [{
      field: 'type',
      width: tableColumnWidths.type,
      name: _i18n.i18n.translate('xpack.reporting.exports.tableColumns.typeTitle', {
        defaultMessage: 'Type'
      }),
      render: (_type, job) => {
        return /*#__PURE__*/_react.default.createElement("div", {
          css: ({
            euiTheme
          }) => (0, _react2.css)({
            paddingLeft: euiTheme.size.s
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 242,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          type: (0, _utils.guessAppIconTypeFromObjectType)(job.objectType),
          size: "s",
          "data-test-subj": "reportJobType",
          content: (0, _utils.getDisplayNameFromObjectType)(job.objectType),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 243,
            columnNumber: 15
          }
        }));
      },
      mobileOptions: {
        show: true,
        render: job => {
          return /*#__PURE__*/_react.default.createElement("div", {
            "data-test-subj": "reportJobType",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 255,
              columnNumber: 20
            }
          }, job.objectType);
        }
      }
    }, {
      field: 'title',
      name: _i18n.i18n.translate('xpack.reporting.exports.tableColumns.reportTitle', {
        defaultMessage: 'Name'
      }),
      width: tableColumnWidths.title,
      render: (objectTitle, job) => {
        return /*#__PURE__*/_react.default.createElement("div", {
          "data-test-subj": "reportingListItemObjectTitle",
          css: ({
            euiTheme
          }) => (0, _react2.css)({
            paddingTop: euiTheme.size.s
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 267,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": `viewReportingLink-${job.id}`,
          onClick: () => this.setState({
            selectedJob: job
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 271,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_truncated_title.TruncatedTitle, {
          text: objectTitle || _i18n.i18n.translate('xpack.reporting.exports.table.noTitleLabel', {
            defaultMessage: 'Untitled'
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 275,
            columnNumber: 17
          }
        })));
      },
      mobileOptions: {
        header: false,
        width: '100%' // This is not recognized by EUI types but has an effect, leaving for now
      }
    }, {
      field: 'status',
      width: tableColumnWidths.status,
      name: _i18n.i18n.translate('xpack.reporting.exports.tableColumns.statusTitle', {
        defaultMessage: 'Status'
      }),
      render: (_status, job) => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "none",
          responsive: false,
          alignItems: "center",
          "data-test-subj": "reportJobStatus",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 300,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_.ReportStatusIndicator, {
          job: job,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 306,
            columnNumber: 15
          }
        }));
      },
      mobileOptions: {
        show: false
      }
    }, {
      field: 'created_at',
      width: tableColumnWidths.createdAt,
      name: _i18n.i18n.translate('xpack.reporting.exports.tableColumns.createdAtTitle', {
        defaultMessage: 'Created at'
      }),
      render: (_createdAt, job) => /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": "reportJobCreatedAt",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 321,
          columnNumber: 11
        }
      }, job.getCreatedAtDate()),
      mobileOptions: {
        show: false
      }
    }, {
      field: 'content',
      width: tableColumnWidths.content,
      name: _i18n.i18n.translate('xpack.reporting.exports.tableColumns.content', {
        defaultMessage: 'Content'
      }),
      render: (_status, job) => /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": "reportJobContent",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 334,
          columnNumber: 11
        }
      }, (0, _job_utils.prettyPrintJobType)(job.jobtype)),
      mobileOptions: {
        show: false
      }
    }, {
      field: 'scheduled_report_id',
      width: tableColumnWidths.exportType,
      name: _i18n.i18n.translate('xpack.reporting.exports.tableColumns.exportType', {
        defaultMessage: 'Export type'
      }),
      render: _scheduledReportId => {
        const exportType = _scheduledReportId ? _i18n.i18n.translate('xpack.reporting.exports.exportType.scheduled', {
          defaultMessage: 'Scheduled'
        }) : _i18n.i18n.translate('xpack.reporting.exports.exportType.single', {
          defaultMessage: 'Single'
        });
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          "data-test-subj": `reportExportType-${exportType}`,
          color: "hollow",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 356,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          alignItems: "center",
          responsive: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 357,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 358,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          type: _scheduledReportId ? 'calendar' : 'download',
          size: "s",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 359,
            columnNumber: 19
          }
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 361,
            columnNumber: 17
          }
        }, exportType)));
      },
      mobileOptions: {
        show: false
      }
    }, {
      name: _i18n.i18n.translate('xpack.reporting.exports.tableColumns.actionsTitle', {
        defaultMessage: 'Actions'
      }),
      width: tableColumnWidths.actions,
      actions: [{
        isPrimary: true,
        'data-test-subj': job => `reportDownloadLink-${job.id}`,
        type: 'icon',
        icon: 'download',
        name: _i18n.i18n.translate('xpack.reporting.exports.table.downloadReportButtonLabel', {
          defaultMessage: 'Download report'
        }),
        description: _i18n.i18n.translate('xpack.reporting.exports.table.downloadReportDescription', {
          defaultMessage: 'Download this report in a new tab.'
        }),
        onClick: job => this.props.apiClient.downloadReport(job.id),
        enabled: job => job.isDownloadReady
      }, {
        name: _i18n.i18n.translate('xpack.reporting.exports.table.viewReportingInfoActionButtonLabel', {
          defaultMessage: 'View report info'
        }),
        description: _i18n.i18n.translate('xpack.reporting.exports.table.viewReportingInfoActionButtonDescription', {
          defaultMessage: 'View additional information about this report.'
        }),
        'data-test-subj': 'reportViewInfoLink',
        type: 'icon',
        icon: 'info',
        onClick: job => this.setState({
          selectedJob: job
        })
      }, {
        name: job => _i18n.i18n.translate('xpack.reporting.schedules.table.openDashboard.title', {
          defaultMessage: 'Open in {objectType}',
          values: {
            objectType: job.objectType ? (0, _utils.getDisplayNameFromObjectType)(job.objectType) : 'Kibana'
          }
        }),
        'data-test-subj': 'reportOpenInKibanaApp',
        description: _i18n.i18n.translate('xpack.reporting.exports.table.openInKibanaAppDescription', {
          defaultMessage: 'Open the Kibana app where this report was generated.'
        }),
        available: job => job.canLinkToKibanaApp,
        type: 'icon',
        icon: 'popout',
        onClick: job => {
          const href = this.props.apiClient.getKibanaAppHref(job);
          window.open(href, '_blank');
          window.focus();
        }
      }]
    }];
    const pagination = {
      pageIndex: this.state.page,
      pageSize: this.state.perPage,
      totalItemCount: this.state.total,
      showPerPageOptions: true
    };
    const selection = {
      itemId: 'id',
      onSelectionChange: this.onSelectionChange
    };
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 451,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: 'l',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 452,
        columnNumber: 9
      }
    }), this.state.selectedJobs.length > 0 && /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 454,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "flexStart",
      gutterSize: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 455,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 456,
        columnNumber: 15
      }
    }, this.renderDeleteButton())), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 458,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      tableCaption: _i18n.i18n.translate('xpack.reporting.exports.table.captionDescription', {
        defaultMessage: 'Reports generated in Kibana applications'
      }),
      itemId: "id",
      items: this.state.jobs,
      loading: this.state.isLoading,
      columns: tableColumns,
      noItemsMessage: _translations.NO_CREATED_REPORTS_DESCRIPTION,
      pagination: pagination,
      selection: selection,
      onChange: this.onTableChange,
      "data-test-subj": _reportingCommon.REPORT_TABLE_ID,
      rowProps: () => ({
        'data-test-subj': _reportingCommon.REPORT_TABLE_ROW_ID
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 461,
        columnNumber: 9
      }
    }), !!this.state.selectedJob && /*#__PURE__*/_react.default.createElement(_.ReportInfoFlyout, {
      config: this.props.config,
      onClose: () => this.setState({
        selectedJob: undefined
      }),
      job: this.state.selectedJob,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 477,
        columnNumber: 11
      }
    }));
  }
}

// eslint-disable-next-line import/no-default-export
exports.default = exports.ReportExportsTable = ReportExportsTable;