"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DifferentialTopNFunctionsView = DifferentialTopNFunctionsView;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _ebtTools = require("@kbn/ebt-tools");
var _async_component = require("../../../components/async_component");
var _use_profiling_dependencies = require("../../../components/contexts/profiling_dependencies/use_profiling_dependencies");
var _frames_summary = require("../../../components/frames_summary");
var _differential_topn_functions_grid = require("../../../components/differential_topn_functions_grid");
var _normalization_menu = require("../../../components/normalization_menu");
var _primary_and_comparison_search_bar = require("../../../components/primary_and_comparison_search_bar");
var _use_async = require("../../../hooks/use_async");
var _use_profiling_params = require("../../../hooks/use_profiling_params");
var _use_profiling_router = require("../../../hooks/use_profiling_router");
var _use_profiling_route_path = require("../../../hooks/use_profiling_route_path");
var _use_time_range = require("../../../hooks/use_time_range");
var _use_time_range_async = require("../../../hooks/use_time_range_async");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/views/functions/differential_topn/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DifferentialTopNFunctionsView() {
  var _state$data2;
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  const {
    query
  } = (0, _use_profiling_params.useProfilingParams)('/functions/differential');
  const {
    rangeFrom,
    rangeTo,
    kuery,
    sortDirection,
    sortField,
    comparisonKuery,
    normalizationMode,
    comparisonRangeFrom,
    comparisonRangeTo,
    baseline = 1,
    comparison = 1,
    pageIndex = 0,
    comparisonSortDirection,
    comparisonSortField,
    searchFunctionName = ''
  } = query;
  const timeRange = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const comparisonTimeRange = (0, _use_time_range.useTimeRange)({
    rangeFrom: comparisonRangeFrom,
    rangeTo: comparisonRangeTo,
    optional: true
  });
  const totalSeconds = timeRange.inSeconds.end - timeRange.inSeconds.start;
  const totalComparisonSeconds = comparisonTimeRange.inSeconds.end - comparisonTimeRange.inSeconds.start;
  const comparisonTime = totalSeconds / totalComparisonSeconds;
  const baselineTime = 1;
  const normalizationOptions = {
    baselineScale: baseline,
    baselineTime,
    comparisonScale: comparison,
    comparisonTime
  };
  const {
    services: {
      fetchTopNFunctions
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const state = (0, _use_time_range_async.useTimeRangeAsync)(({
    http
  }) => {
    return fetchTopNFunctions({
      http,
      timeFrom: new Date(timeRange.start).getTime(),
      timeTo: new Date(timeRange.end).getTime(),
      startIndex: 0,
      endIndex: 100000,
      kuery
    });
  }, [fetchTopNFunctions, timeRange.start, timeRange.end, kuery]);
  const comparisonState = (0, _use_time_range_async.useTimeRangeAsync)(({
    http
  }) => {
    if (!comparisonTimeRange.start || !comparisonTimeRange.end) {
      return undefined;
    }
    return fetchTopNFunctions({
      http,
      timeFrom: new Date(comparisonTimeRange.start).getTime(),
      timeTo: new Date(comparisonTimeRange.end).getTime(),
      startIndex: 0,
      endIndex: 100000,
      kuery: comparisonKuery
    });
  }, [comparisonTimeRange.start, comparisonTimeRange.end, fetchTopNFunctions, comparisonKuery]);
  const routePath = (0, _use_profiling_route_path.useProfilingRoutePath)();
  const profilingRouter = (0, _use_profiling_router.useProfilingRouter)();
  function onChangeNormalizationMode(nextNormalizationMode, options) {
    profilingRouter.push(routePath, {
      path: routePath,
      query: nextNormalizationMode === _normalization_menu.NormalizationMode.Scale ? {
        ...query,
        baseline: options.baselineScale,
        comparison: options.comparisonScale,
        normalizationMode: nextNormalizationMode
      } : {
        ...query,
        normalizationMode: nextNormalizationMode
      }
    });
  }
  const isNormalizedByTime = normalizationMode === _normalization_menu.NormalizationMode.Time;
  function handleOnFrameClick(value) {
    profilingRouter.push('/flamegraphs/flamegraph', {
      path: {},
      query: {
        ...query,
        searchText: value
      }
    });
  }
  function handlePageChange(nextPage) {
    profilingRouter.push('/functions/differential', {
      path: {},
      query: {
        ...query,
        pageIndex: nextPage
      }
    });
  }
  function handleOnSort(sorting) {
    profilingRouter.push('/functions/differential', {
      path: {},
      query: {
        ...query,
        ...sorting
      }
    });
  }
  function handleSearchFunctionNameChange(value) {
    profilingRouter.push('/functions/differential', {
      path: {},
      query: {
        ...query,
        searchFunctionName: value
      }
    });
  }
  (0, _react.useEffect)(() => {
    if (state.status === _use_async.AsyncStatus.Settled || comparisonState.status === _use_async.AsyncStatus.Settled) {
      var _state$data$TotalCoun, _state$data;
      onPageReady({
        meta: {
          rangeFrom,
          rangeTo
        },
        customMetrics: {
          key1: 'totalCount',
          value1: (_state$data$TotalCoun = (_state$data = state.data) === null || _state$data === void 0 ? void 0 : _state$data.TotalCount) !== null && _state$data$TotalCoun !== void 0 ? _state$data$TotalCoun : 0
        }
      });
    }
  }, [state.status, (_state$data2 = state.data) === null || _state$data2 === void 0 ? void 0 : _state$data2.TotalCount, comparisonState.status, onPageReady, rangeTo, rangeFrom]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_primary_and_comparison_search_bar.PrimaryAndComparisonSearchBar, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_normalization_menu.NormalizationMenu, {
    mode: normalizationMode,
    options: normalizationOptions,
    onChange: onChangeNormalizationMode,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_frames_summary.FramesSummary, {
    isLoading: state.status === _use_async.AsyncStatus.Loading || comparisonState.status === _use_async.AsyncStatus.Loading,
    baseValue: state.data ? {
      totalCount: state.data.selfCPU,
      scaleFactor: isNormalizedByTime ? baselineTime : baseline,
      totalAnnualCO2Kgs: state.data.totalAnnualCO2Kgs,
      totalAnnualCostUSD: state.data.totalAnnualCostUSD
    } : undefined,
    comparisonValue: comparisonState.data ? {
      totalCount: comparisonState.data.selfCPU,
      scaleFactor: isNormalizedByTime ? comparisonTime : comparison,
      totalAnnualCO2Kgs: comparisonState.data.totalAnnualCO2Kgs,
      totalAnnualCostUSD: comparisonState.data.totalAnnualCostUSD
    } : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_async_component.AsyncComponent, (0, _extends2.default)({}, comparisonState.status === _use_async.AsyncStatus.Loading ? comparisonState : state, {
    size: "xl",
    alignTop: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_differential_topn_functions_grid.DifferentialTopNFunctionsGrid, {
    base: state.data,
    baselineScaleFactor: isNormalizedByTime ? comparisonTime : comparison,
    comparison: comparisonState.data,
    comparisonScaleFactor: isNormalizedByTime ? baselineTime : baseline,
    comparisonSortDirection: comparisonSortDirection,
    comparisonSortField: comparisonSortField,
    comparisonTotalSeconds: totalComparisonSeconds,
    onChangePage: handlePageChange,
    onChangeSort: handleOnSort,
    onFrameClick: handleOnFrameClick,
    pageIndex: pageIndex,
    sortDirection: sortDirection,
    sortField: sortField,
    totalSeconds: totalSeconds,
    searchFunctionName: searchFunctionName,
    onSearchFunctionNameChange: handleSearchFunctionNameChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 13
    }
  })))));
}