"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildResultsQuery = void 0;
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment/moment"));
var _build_index_name_with_namespace = require("../../../../utils/build_index_name_with_namespace");
var _build_query = require("../../../../utils/build_query");
var _common = require("../../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildResultsQuery = ({
  actionId,
  agentId,
  kuery,
  sort,
  startDate,
  pagination: {
    activePage,
    querySize
  },
  integrationNamespaces
}) => {
  var _sort$map;
  const baseIndex = `logs-${_common.OSQUERY_INTEGRATION_NAME}.result*`;
  const actionIdQuery = `action_id: ${actionId}`;
  const agentQuery = agentId ? ` AND agent.id: ${agentId}` : '';
  let filter = actionIdQuery + agentQuery;
  if (!(0, _lodash.isEmpty)(kuery)) {
    filter = filter + ` AND ${kuery}`;
  }
  const timeRangeFilter = startDate && !(0, _lodash.isEmpty)(startDate) ? [{
    range: {
      '@timestamp': {
        gte: startDate,
        lte: (0, _moment.default)(startDate).clone().add(30, 'minutes').toISOString()
      }
    }
  }] : [];
  const filterQuery = [...timeRangeFilter, (0, _build_query.getQueryFilter)({
    filter
  })];
  let index;
  if (integrationNamespaces && integrationNamespaces.length > 0) {
    index = integrationNamespaces.map(namespace => (0, _build_index_name_with_namespace.buildIndexNameWithNamespace)(baseIndex, namespace)).join(',');
  } else {
    index = baseIndex;
  }
  return {
    allow_no_indices: true,
    index,
    ignore_unavailable: true,
    aggs: {
      count_by_agent_id: {
        terms: {
          field: 'elastic_agent.id',
          size: 10000
        }
      },
      unique_agents: {
        cardinality: {
          field: 'elastic_agent.id'
        }
      }
    },
    query: {
      bool: {
        filter: filterQuery
      }
    },
    from: activePage * querySize,
    size: querySize,
    track_total_hits: true,
    fields: ['elastic_agent.*', 'agent.*', 'osquery.*'],
    sort: (_sort$map = sort === null || sort === void 0 ? void 0 : sort.map(sortConfig => ({
      [sortConfig.field]: {
        order: sortConfig.direction
      }
    }))) !== null && _sort$map !== void 0 ? _sort$map : []
  };
};
exports.buildResultsQuery = buildResultsQuery;