"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackFieldWrapper = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _reactHookForm = require("react-hook-form");
var _pack_queries_status_table = require("../../live_queries/form/pack_queries_status_table");
var _use_packs = require("../../packs/use_packs");
var _packs_combobox_field = require("../../live_queries/form/packs_combobox_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/shared_components/osquery_response_action_type/pack_field_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PackFieldWrapper = ({
  liveQueryDetails,
  submitButtonContent,
  showResultsHeader
}) => {
  var _liveQueryDetails$que, _selectedPackData$que, _liveQueryDetails$que2;
  const {
    data: packsData
  } = (0, _use_packs.usePacks)({});
  const {
    packId
  } = (0, _reactHookForm.useWatch)();
  const selectedPackData = (0, _react.useMemo)(() => packId !== null && packId !== void 0 && packId.length ? (0, _lodash.find)(packsData === null || packsData === void 0 ? void 0 : packsData.data, {
    saved_object_id: packId[0]
  }) : null, [packId, packsData]);
  const actionId = (0, _react.useMemo)(() => liveQueryDetails === null || liveQueryDetails === void 0 ? void 0 : liveQueryDetails.action_id, [liveQueryDetails === null || liveQueryDetails === void 0 ? void 0 : liveQueryDetails.action_id]);
  const agentIds = (0, _react.useMemo)(() => liveQueryDetails === null || liveQueryDetails === void 0 ? void 0 : liveQueryDetails.agents, [liveQueryDetails === null || liveQueryDetails === void 0 ? void 0 : liveQueryDetails.agents]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_packs_combobox_field.PacksComboBoxField
  // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
  , {
    fieldProps: {
      packsData: packsData === null || packsData === void 0 ? void 0 : packsData.data
    },
    queryType: "pack",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  })), submitButtonContent, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }), liveQueryDetails !== null && liveQueryDetails !== void 0 && (_liveQueryDetails$que = liveQueryDetails.queries) !== null && _liveQueryDetails$que !== void 0 && _liveQueryDetails$que.length || selectedPackData !== null && selectedPackData !== void 0 && (_selectedPackData$que = selectedPackData.queries) !== null && _selectedPackData$que !== void 0 && _selectedPackData$que.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_pack_queries_status_table.PackQueriesStatusTable, {
    actionId: actionId,
    agentIds: agentIds
    // @ts-expect-error update types
    ,
    data: (_liveQueryDetails$que2 = liveQueryDetails === null || liveQueryDetails === void 0 ? void 0 : liveQueryDetails.queries) !== null && _liveQueryDetails$que2 !== void 0 ? _liveQueryDetails$que2 : selectedPackData === null || selectedPackData === void 0 ? void 0 : selectedPackData.queries,
    showResultsHeader: showResultsHeader,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  })) : null);
};
exports.PackFieldWrapper = PackFieldWrapper;