"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryFlyout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactHookForm = require("react-hook-form");
var _constants = require("../../../common/constants");
var _form = require("../../form");
var _code_editor_field = require("../../saved_queries/form/code_editor_field");
var _platform_checkbox_group_field = require("./platform_checkbox_group_field");
var _constants2 = require("./constants");
var _use_pack_query_form = require("./use_pack_query_form");
var _saved_queries_dropdown = require("../../saved_queries/saved_queries_dropdown");
var _lazy_ecs_mapping_editor_field = require("./lazy_ecs_mapping_editor_field");
var _kibana = require("../../common/lib/kibana");
var _utils = require("../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/packs/queries/query_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const QueryFlyoutComponent = ({
  uniqueQueryIds,
  defaultValue,
  onSave,
  onClose
}) => {
  const permissions = (0, _kibana.useKibana)().services.application.capabilities.osquery;
  const [isEditMode] = (0, _react.useState)(!!defaultValue);
  const {
    serializer,
    idSet,
    ...hooksForm
  } = (0, _use_pack_query_form.usePackQueryForm)({
    uniqueQueryIds,
    defaultValue
  });
  const {
    handleSubmit,
    formState: {
      isSubmitting
    },
    resetField
  } = hooksForm;
  const onSubmit = async payload => {
    const serializedData = serializer(payload);
    await onSave(serializedData);
    onClose();
  };
  const handleSetQueryValue = (0, _react.useCallback)(savedQuery => {
    if (savedQuery) {
      var _savedQuery$snapshot, _savedQuery$ecs_mappi;
      resetField('id', {
        defaultValue: savedQuery.id
      });
      resetField('query', {
        defaultValue: savedQuery.query
      });
      resetField('platform', {
        defaultValue: savedQuery.platform ? savedQuery.platform : _constants.DEFAULT_PLATFORM
      });
      resetField('version', {
        defaultValue: savedQuery.version ? [savedQuery.version] : []
      });
      resetField('interval', {
        defaultValue: savedQuery.interval ? savedQuery.interval : 3600
      });
      resetField('timeout', {
        defaultValue: savedQuery.timeout ? savedQuery.timeout : _constants.QUERY_TIMEOUT.DEFAULT
      });
      resetField('snapshot', {
        defaultValue: (_savedQuery$snapshot = savedQuery.snapshot) !== null && _savedQuery$snapshot !== void 0 ? _savedQuery$snapshot : true
      });
      resetField('removed', {
        defaultValue: savedQuery.removed
      });
      resetField('ecs_mapping', {
        defaultValue: (_savedQuery$ecs_mappi = savedQuery.ecs_mapping) !== null && _savedQuery$ecs_mappi !== void 0 ? _savedQuery$ecs_mappi : {}
      });
    }
  }, [resetField]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    size: "m",
    onClose: onClose,
    "aria-labelledby": "flyoutTitle",
    ownFocus: true,
    outsideClickCloses: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "flyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }, isEditMode ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.queryFlyoutForm.editFormTitle",
    defaultMessage: "Edit query",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.queryFlyoutForm.addFormTitle",
    defaultMessage: "Attach next query",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, (0, _extends2.default)({}, hooksForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }), !isEditMode && permissions.readSavedQueries ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_saved_queries_dropdown.SavedQueriesDropdown, {
    onChange: handleSetQueryValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 15
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_form.QueryIdField, {
    idSet: idSet,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_code_editor_field.CodeEditorField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_form.IntervalField
  // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
  , {
    euiFieldProps: {
      append: 's'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_form.VersionField
  // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
  , {
    euiFieldProps: {
      noSuggestions: false,
      singleSelection: {
        asPlainText: true
      },
      placeholder: _i18n.i18n.translate('xpack.osquery.queriesTable.osqueryVersionAllLabel', {
        defaultMessage: 'ALL'
      }),
      options: _constants2.ALL_OSQUERY_VERSIONS_OPTIONS,
      onCreateOption: undefined
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_form.ResultsTypeField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: 'column',
    justifyContent: 'spaceBetween',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_platform_checkbox_group_field.PlatformCheckBoxGroupField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_form.TimeoutField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: _utils.overflowCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_lazy_ecs_mapping_editor_field.ECSMappingEditorField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "query-flyout-cancel-button",
    iconType: "cross",
    onClick: onClose,
    flush: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.queryFlyoutForm.cancelButtonLabel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "query-flyout-save-button",
    isLoading: isSubmitting,
    onClick: handleSubmit(onSubmit),
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.queryFlyoutForm.saveButtonLabel",
    defaultMessage: "Save",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 15
    }
  }))))));
};
const QueryFlyout = exports.QueryFlyout = /*#__PURE__*/_react.default.memo(QueryFlyoutComponent);