"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShardsPercentageField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/packs/form/shards/shards_percentage_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ShardsPercentageFieldComponent = ({
  index,
  control,
  euiFieldProps,
  hideLabel
}) => {
  const {
    field: {
      onChange,
      value
    },
    fieldState: {
      error
    }
  } = (0, _reactHookForm.useController)({
    control,
    name: `shardsArray.${index}.percentage`,
    defaultValue: 100
  });
  const handleChange = (0, _react.useCallback)(e => {
    const numberValue = e.target.valueAsNumber ? e.target.valueAsNumber : 0;
    onChange(numberValue);
  }, [onChange]);
  const hasError = (0, _react.useMemo)(() => !!(error !== null && error !== void 0 && error.message), [error === null || error === void 0 ? void 0 : error.message]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: hideLabel ? '' : _i18n.i18n.translate('xpack.osquery.pack.form.percentageFieldLabel', {
      defaultMessage: 'Shard'
    }),
    error: error === null || error === void 0 ? void 0 : error.message,
    isInvalid: hasError,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 10,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, (0, _extends2.default)({
    "data-test-subj": "shards-field-percentage",
    id: 'shardsPercentage' + index,
    min: 0,
    max: 100,
    step: 1,
    value: value,
    fullWidth: true,
    showInput: true,
    showLabels: false,
    append: '%',
    onChange: handleChange
  }, euiFieldProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  })))));
};
const ShardsPercentageField = exports.ShardsPercentageField = /*#__PURE__*/_react.default.memo(ShardsPercentageFieldComponent);