"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useExecuteTool = void 0;
var _reactQuery = require("@tanstack/react-query");
var _use_onechat_service = require("../use_onechat_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useExecuteTool = ({
  onSuccess,
  onError,
  onSettled
} = {}) => {
  const {
    toolsService
  } = (0, _use_onechat_service.useOnechatServices)();
  const mutationFn = ({
    toolId,
    toolParams
  }) => toolsService.execute({
    toolId,
    toolParams
  });
  const {
    mutateAsync,
    isLoading,
    error
  } = (0, _reactQuery.useMutation)(mutationFn, {
    onSuccess,
    onError,
    onSettled
  });
  return {
    executeTool: mutateAsync,
    isLoading,
    error
  };
};
exports.useExecuteTool = useExecuteTool;