"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createOrUpdateIndexTemplate = createOrUpdateIndexTemplate;
var _pRetry = _interopRequireDefault(require("p-retry"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function createOrUpdateIndexTemplate({
  indexTemplate,
  client,
  logger
}) {
  try {
    /*
     * In some cases we could be trying to create the index template before ES is ready.
     * When this happens, we retry creating the template with exponential backoff.
     * We use retry's default formula, meaning that the first retry happens after 2s,
     * the 5th after 32s, and the final attempt after around 17m. If the final attempt fails,
     * the error is logged to the console.
     * See https://github.com/sindresorhus/p-retry and https://github.com/tim-kos/node-retry.
     */
    return await (0, _pRetry.default)(async () => {
      logger.debug(`Create index template: "${indexTemplate.name}" for index pattern "${indexTemplate.index_patterns}"`);
      const result = await client.indices.putIndexTemplate(indexTemplate);
      if (!result.acknowledged) {
        var _result$body;
        // @ts-expect-error
        const resultError = JSON.stringify(result === null || result === void 0 ? void 0 : (_result$body = result.body) === null || _result$body === void 0 ? void 0 : _result$body.error);
        throw new Error(resultError);
      }
      return result;
    }, {
      onFailedAttempt: e => {
        logger.warn(`Could not create index template: '${indexTemplate.name}'. Retrying...`, {
          error: e
        });
      }
    });
  } catch (e) {
    logger.error(`Could not create index template: '${indexTemplate.name}'. Error: ${e.message}.`, {
      error: e
    });
  }
}