"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Plugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/cases-plugin/public");
var _public2 = require("@kbn/core/public");
var _common = require("@kbn/discover-plugin/common");
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _common2 = require("../common");
var _paths = require("../common/locators/paths");
var _data_handler = require("./context/has_data_context/data_handler");
var _create_use_rules_link = require("./hooks/create_use_rules_link");
var _rule_details = require("./locators/rule_details");
var _rules = require("./locators/rules");
var _create_observability_rule_type_registry = require("./rules/create_observability_rule_type_registry");
var _register_observability_rule_types = require("./rules/register_observability_rule_types");
var _cases = require("../common/locators/cases");
var _telemetry_service = require("./services/telemetry/telemetry_service");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class Plugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "appUpdater$", new _rxjs.BehaviorSubject(() => ({})));
    (0, _defineProperty2.default)(this, "observabilityRuleTypeRegistry", {});
    (0, _defineProperty2.default)(this, "telemetry", void 0);
    (0, _defineProperty2.default)(this, "isServerless", false);
    // Define deep links as constant and hidden. Whether they are shown or hidden
    // in the global navigation will happen in `updateGlobalNavigation`.
    (0, _defineProperty2.default)(this, "deepLinks", [{
      id: 'alerts',
      title: _i18n.i18n.translate('xpack.observability.alertsLinkTitle', {
        defaultMessage: 'Alerts'
      }),
      order: 8001,
      path: _paths.ALERTS_PATH,
      visibleIn: [],
      deepLinks: [{
        id: 'rules',
        title: _i18n.i18n.translate('xpack.observability.rulesLinkTitle', {
          defaultMessage: 'Rules'
        }),
        path: _paths.RULES_PATH,
        visibleIn: []
      }]
    }]);
    this.initContext = initContext;
    this.telemetry = new _telemetry_service.TelemetryService();
    this.isServerless = initContext.env.packageInfo.buildFlavor === 'serverless';
  }
  setup(coreSetup, pluginsSetup) {
    const startServicesPromise = coreSetup.getStartServices();
    if (pluginsSetup.cases) {
      this.deepLinks.push((0, _public.getCasesDeepLinks)({
        basePath: _paths.CASES_PATH,
        extend: {
          [_public.CasesDeepLinkId.cases]: {
            order: 8003,
            visibleIn: []
          },
          [_public.CasesDeepLinkId.casesCreate]: {
            visibleIn: []
          },
          [_public.CasesDeepLinkId.casesConfigure]: {
            visibleIn: []
          }
        }
      }));
    }
    const category = _public2.DEFAULT_APP_CATEGORIES.observability;
    const euiIconType = 'logoObservability';
    const config = this.initContext.config.get();
    const kibanaVersion = this.initContext.env.packageInfo.version;
    this.telemetry.setup(coreSetup.analytics);
    this.observabilityRuleTypeRegistry = (0, _create_observability_rule_type_registry.createObservabilityRuleTypeRegistry)(pluginsSetup.triggersActionsUi.ruleTypeRegistry);
    const rulesLocator = pluginsSetup.share.url.locators.create(new _rules.RulesLocatorDefinition());
    pluginsSetup.share.url.locators.create((0, _cases.CaseDetailsLocatorDefinition)());
    pluginsSetup.share.url.locators.create((0, _cases.CasesOverviewLocatorDefinition)());
    const ruleDetailsLocator = pluginsSetup.share.url.locators.create(new _rule_details.RuleDetailsLocatorDefinition());
    const logsLocator = pluginsSetup.share.url.locators.get(_common.DISCOVER_APP_LOCATOR);
    const mount = async params => {
      // Load application bundle
      const {
        renderApp
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
      // Get start services
      const [coreStart, pluginsStart] = await coreSetup.getStartServices();
      const {
        ruleTypeRegistry,
        actionTypeRegistry
      } = pluginsStart.triggersActionsUi;
      return renderApp({
        appMountParameters: params,
        config,
        core: coreStart,
        isDev: this.initContext.env.mode.dev,
        kibanaVersion,
        observabilityRuleTypeRegistry: this.observabilityRuleTypeRegistry,
        ObservabilityPageTemplate: pluginsStart.observabilityShared.navigation.PageTemplate,
        telemetryClient: this.telemetry.start(coreStart.analytics),
        plugins: {
          ...pluginsStart,
          ruleTypeRegistry,
          actionTypeRegistry
        },
        usageCollection: pluginsSetup.usageCollection,
        isServerless: !!pluginsStart.serverless
      });
    };
    const appUpdater$ = this.appUpdater$;
    const app = {
      appRoute: _paths.OBSERVABILITY_BASE_PATH,
      category,
      deepLinks: this.deepLinks,
      euiIconType,
      id: _common2.observabilityAppId,
      mount,
      order: 8000,
      title: _i18n.i18n.translate('xpack.observability.overviewLinkTitle', {
        defaultMessage: 'Overview'
      }),
      updater$: appUpdater$,
      keywords: ['observability', 'monitor', 'logs', 'metrics', 'apm', 'slo', 'performance', 'trace', 'agent', 'rum', 'user', 'experience'],
      visibleIn: Boolean(pluginsSetup.serverless) ? ['home', 'kibanaOverview'] : ['globalSearch', 'home', 'kibanaOverview', 'sideNav']
    };
    coreSetup.application.register(app);
    (0, _register_observability_rule_types.registerObservabilityRuleTypes)(this.observabilityRuleTypeRegistry, coreSetup.uiSettings, logsLocator);
    if (pluginsSetup.home) {
      pluginsSetup.home.featureCatalogue.registerSolution({
        id: _common2.observabilityFeatureId,
        title: _i18n.i18n.translate('xpack.observability.featureCatalogueTitle', {
          defaultMessage: 'Observability'
        }),
        description: _i18n.i18n.translate('xpack.observability.featureCatalogueDescription', {
          defaultMessage: 'Consolidate your logs, metrics, application traces, and system availability with purpose-built UIs.'
        }),
        icon: 'logoObservability',
        path: `${_paths.OBSERVABILITY_BASE_PATH}/`,
        order: 200,
        isVisible: capabilities => {
          const obs = capabilities.catalogue[_common2.observabilityFeatureId];
          const uptime = capabilities.catalogue.uptime;
          const infra = capabilities.catalogue.infra;
          const apm = capabilities.catalogue.apm;
          return obs || uptime || infra || apm;
        }
      });
    }
    pluginsSetup.observabilityShared.navigation.registerSections((0, _rxjs.from)(appUpdater$).pipe((0, _rxjs.mergeMap)(value => (0, _rxjs.from)(coreSetup.getStartServices()).pipe((0, _rxjs.map)(([coreStart, pluginsStart]) => {
      var _value$deepLinks, _value, _pluginsStart$observa, _coreStart$applicatio;
      const deepLinks = (_value$deepLinks = (_value = value(app)) === null || _value === void 0 ? void 0 : _value.deepLinks) !== null && _value$deepLinks !== void 0 ? _value$deepLinks : [];
      const overviewLink = !Boolean(pluginsSetup.serverless) ? [{
        label: _i18n.i18n.translate('xpack.observability.overviewLinkTitle', {
          defaultMessage: 'Overview'
        }),
        app: _common2.observabilityAppId,
        path: _paths.OVERVIEW_PATH
      }] : [];
      const isAiAssistantEnabled = (_pluginsStart$observa = pluginsStart.observabilityAIAssistant) === null || _pluginsStart$observa === void 0 ? void 0 : _pluginsStart$observa.service.isEnabled();
      const aiAssistantLink = isAiAssistantEnabled && !Boolean(pluginsSetup.serverless) && Boolean(pluginsSetup.observabilityAIAssistant) ? [{
        label: _i18n.i18n.translate('xpack.observability.aiAssistantLinkTitle', {
          defaultMessage: 'AI Assistant'
        }),
        app: 'observabilityAIAssistant',
        path: '/conversations/new'
      }] : [];
      const sloLink = (_coreStart$applicatio = coreStart.application.capabilities.slo) !== null && _coreStart$applicatio !== void 0 && _coreStart$applicatio.read ? [{
        label: _i18n.i18n.translate('xpack.observability.sloLinkTitle', {
          defaultMessage: 'SLOs'
        }),
        app: 'slo',
        path: ''
      }] : [];

      // Reformat the visible links to be NavigationEntry objects instead of
      // AppDeepLink objects.
      //
      // In our case the deep links and sections being registered are the
      // same, and the logic to hide them based on flags or capabilities is
      // the same, so we just want to make a new list with the properties
      // needed by `registerSections`, which are different than the
      // properties used by the deepLinks.
      //
      // See https://github.com/elastic/kibana/issues/103325.
      const otherLinks = deepLinks.filter(link => {
        var _link$visibleIn;
        return ((_link$visibleIn = link.visibleIn) !== null && _link$visibleIn !== void 0 ? _link$visibleIn : []).length > 0;
      });
      const alertsLink = otherLinks.filter(link => link.id === 'alerts').map(link => {
        var _link$path;
        return {
          app: _common2.observabilityAppId,
          label: link.title,
          path: (_link$path = link.path) !== null && _link$path !== void 0 ? _link$path : ''
        };
      });
      const casesLink = otherLinks.filter(link => link.id === 'cases' && pluginsStart.cases).map(link => {
        var _link$path2;
        return {
          app: _common2.observabilityAppId,
          label: link.title,
          path: (_link$path2 = link.path) !== null && _link$path2 !== void 0 ? _link$path2 : ''
        };
      });
      return [{
        label: '',
        sortKey: 100,
        entries: [...overviewLink, ...alertsLink, ...sloLink, ...casesLink, ...aiAssistantLink]
      }];
    })))));
    pluginsSetup.observabilityShared.navigation.registerSections((0, _rxjs.from)(startServicesPromise).pipe((0, _rxjs.switchMap)(([_, pluginsStart]) => pluginsStart.streams.navigationStatus$.pipe((0, _rxjs.map)(({
      status
    }) => {
      if (status !== 'enabled') {
        return [];
      }
      return [{
        label: '',
        sortKey: 101,
        entries: [{
          label: _i18n.i18n.translate('xpack.observability.streamsAppLinkTitle', {
            defaultMessage: 'Streams'
          }),
          app: 'streams',
          path: '/',
          isTechnicalPreview: this.isServerless,
          matchPath(currentPath) {
            return ['/', ''].some(testPath => currentPath.startsWith(testPath));
          }
        }]
      }];
    })))));
    return {
      dashboard: {
        register: _data_handler.registerDataHandler
      },
      observabilityRuleTypeRegistry: this.observabilityRuleTypeRegistry,
      useRulesLink: (0, _create_use_rules_link.createUseRulesLink)(),
      rulesLocator,
      ruleDetailsLocator,
      config
    };
  }
  start(coreStart, pluginsStart) {
    const {
      application
    } = coreStart;
    const config = this.initContext.config.get();
    pluginsStart.observabilityShared.updateGlobalNavigation({
      capabilities: application.capabilities,
      deepLinks: this.deepLinks,
      updater$: this.appUpdater$,
      pricing: coreStart.pricing
    });
    Promise.resolve().then(() => _interopRequireWildcard(require('./navigation_tree'))).then(({
      createDefinition
    }) => {
      return pluginsStart.navigation.addSolutionNavigation(createDefinition(pluginsStart));
    });
    return {
      config,
      observabilityRuleTypeRegistry: this.observabilityRuleTypeRegistry,
      useRulesLink: (0, _create_use_rules_link.createUseRulesLink)()
    };
  }
}
exports.Plugin = Plugin;