"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelatedAlertsTable = RelatedAlertsTable;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _responseOpsAlertsTable = require("@kbn/response-ops-alerts-table");
var _common = require("@kbn/observability-shared-plugin/common");
var _get_related_columns = require("./get_related_columns");
var _get_build_related_alerts_query = require("../../hooks/related_alerts/get_build_related_alerts_query");
var _ = require("../../../..");
var _use_plugin_context = require("../../../../hooks/use_plugin_context");
var _kibana_react = require("../../../../utils/kibana_react");
var _constants = require("../../../../../common/constants");
var _cell_value = require("../../../../components/alerts_table/common/cell_value");
var _common2 = require("../../../../../common");
var _use_filter_proximal_param = require("../../hooks/use_filter_proximal_param");
var _related_alerts_table_filter = require("./related_alerts_table_filter");
var _alerts_table_expanded_alert_view = require("../../../../components/alerts_flyout/alerts_table_expanded_alert_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/alert_details/components/related_alerts/related_alerts_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const columns = (0, _get_related_columns.getRelatedColumns)();
const initialSort = [{
  _score: {
    order: 'desc'
  }
}, {
  [_ruleDataUtils.ALERT_START]: {
    order: 'desc'
  }
}, {
  [_ruleDataUtils.ALERT_UUID]: {
    order: 'desc'
  }
}];
const caseConfiguration = {
  featureId: _common2.casesFeatureIdV2,
  owner: [_.observabilityFeatureId]
};
function RelatedAlertsTable({
  alertData
}) {
  const {
    formatted: alert
  } = alertData;
  const {
    filterProximal
  } = (0, _use_filter_proximal_param.useFilterProximalParam)();
  const esQuery = (0, _get_build_related_alerts_query.getBuildRelatedAlertsQuery)({
    alert,
    filterProximal
  });
  const {
    observabilityRuleTypeRegistry,
    config
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    services
  } = (0, _kibana_react.useKibana)();
  const onLoaded = (0, _react.useCallback)(({
    totalAlertsCount
  }) => services.telemetryClient.reportRelatedAlertsLoaded(totalAlertsCount), [services.telemetryClient]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_related_alerts_table_filter.RelatedAlertsTableFilter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_responseOpsAlertsTable.AlertsTable, {
    id: _common.RELATED_ALERTS_TABLE_ID,
    query: esQuery,
    columns: columns,
    onLoaded: onLoaded,
    ruleTypeIds: _constants.OBSERVABILITY_RULE_TYPE_IDS_WITH_SUPPORTED_STACK_RULE_TYPES,
    minScore: 1.5,
    trackScores: true,
    sort: initialSort,
    casesConfiguration: caseConfiguration,
    additionalContext: {
      observabilityRuleTypeRegistry,
      config,
      parentAlert: alert
    },
    toolbarVisibility: {
      showSortSelector: false
    },
    renderCellValue: _cell_value.AlertsTableCellValue,
    renderExpandedAlertView: _alerts_table_expanded_alert_view.AlertsTableExpandedAlertView,
    showAlertStatusWithFlapping: true,
    services: services,
    gridStyle: {
      border: 'horizontal',
      header: 'underline',
      cellPadding: 'l',
      fontSize: 'm'
    },
    rowHeightsOptions: {
      defaultHeight: 'auto'
    },
    height: "600px",
    emptyState: {
      messageTitle: _i18n.i18n.translate('xpack.observability.relatedAlertsTable.emptyState.title', {
        defaultMessage: 'No related alerts found'
      }),
      messageBody: _i18n.i18n.translate('xpack.observability.relatedAlertsTable.emptyState.body', {
        defaultMessage: 'No existing alerts match our related alerts criteria at this time. This may change if more alerts appear, so you may want to check back later.'
      })
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }));
}