"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackageListSearchForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _useAsyncRetry = _interopRequireDefault(require("react-use/lib/useAsyncRetry"));
var _use_card_url_rewrite = require("./use_card_url_rewrite");
var _package_list = require("../package_list/package_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_onboarding/public/application/package_list_search_form/package_list_search_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const fetchAvailablePackagesHook = () => Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/fleet-plugin/public'))).then(module => module.AvailablePackagesHook()).then(hook => hook.useAvailablePackages);
const Loading = () => /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
  isLoading: true,
  lines: 5,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 39,
    columnNumber: 23
  }
});
const PackageListGridWrapper = ({
  useAvailablePackages,
  packageListRef,
  searchQuery,
  setSearchQuery,
  customCards,
  flowCategory,
  excludePackageIdList = []
}) => {
  const {
    filteredCards: integrationCards,
    isLoading
  } = useAvailablePackages({
    prereleaseIntegrationsEnabled: false
  });
  const rewriteUrl = (0, _use_card_url_rewrite.useCardUrlRewrite)({
    category: flowCategory,
    search: searchQuery
  });
  const list = (0, _react.useMemo)(() => {
    return (customCards !== null && customCards !== void 0 ? customCards : []).concat(integrationCards).filter(card => card.categories.some(category => ['observability', 'os_system'].includes(category))).filter(card => !excludePackageIdList.includes(card.id)).map(rewriteUrl);
  }, [customCards, excludePackageIdList, integrationCards, rewriteUrl]);
  if (isLoading) return /*#__PURE__*/_react.default.createElement(Loading, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 25
    }
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: packageListRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    box: {
      incremental: true
    },
    onChange: ({
      queryText,
      error
    }) => {
      if (error) return;
      setSearchQuery(queryText);
    },
    query: searchQuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }), searchQuery !== '' && /*#__PURE__*/_react.default.createElement(_package_list.PackageList, {
    list: list,
    searchTerm: searchQuery,
    showCardLabels: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }));
};
const PackageListSearchForm = exports.PackageListSearchForm = /*#__PURE__*/_react.default.forwardRef((props, packageListRef) => {
  const ref = (0, _react.useRef)(null);
  const {
    error: errorLoading,
    retry: retryAsyncLoad,
    loading: asyncLoading
  } = (0, _useAsyncRetry.default)(async () => {
    ref.current = await fetchAvailablePackagesHook();
  });
  if (errorLoading) return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.observability_onboarding.asyncLoadFailureCallout.title', {
      defaultMessage: 'Loading failure'
    }),
    color: "warning",
    iconType: "cross",
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability_onboarding.asyncLoadFailureCallout.copy",
    defaultMessage: "Some required elements failed to load.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "warning",
    "data-test-subj": "xpack.observability_onboarding.asyncLoadFailureCallout.button",
    onClick: () => {
      if (!asyncLoading) retryAsyncLoad();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability_onboarding.asyncLoadFailureCallout.buttonContent",
    defaultMessage: "Retry",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 13
    }
  })));
  if (asyncLoading || ref.current === null) return /*#__PURE__*/_react.default.createElement(Loading, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 54
    }
  });
  return /*#__PURE__*/_react.default.createElement(PackageListGridWrapper, (0, _extends2.default)({}, props, {
    useAvailablePackages: ref.current,
    packageListRef: packageListRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }));
});