"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeDetailStatus = NodeDetailStatus;
var _react = _interopRequireWildcard(require("react"));
var _summary_status = require("../../summary_status");
var _node = require("../node");
var _format_number = require("../../../lib/format_number");
var _i18n = require("@kbn/i18n");
var _status = require("../../../alerts/status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/elasticsearch/node_detail_status/index.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function NodeDetailStatus({
  stats,
  alerts = {}
}) {
  const {
    transport_address: transportAddress,
    usedHeap,
    freeSpace,
    totalSpace,
    documents,
    dataSize,
    indexCount,
    totalShards,
    nodeTypeLabel,
    status,
    isOnline
  } = stats;
  const percentSpaceUsed = freeSpace / totalSpace * 100;
  const metrics = [{
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.nodeDetailStatus.alerts', {
      defaultMessage: 'Alerts'
    }),
    value: /*#__PURE__*/_react.default.createElement(_status.AlertsStatus, {
      alerts: alerts,
      showOnlyCount: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 14
      }
    })
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.nodeDetailStatus.transportAddress', {
      defaultMessage: 'Transport Address'
    }),
    value: transportAddress,
    'data-test-subj': 'transportAddress'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.nodeDetailStatus.jvmHeapLabel', {
      defaultMessage: '{javaVirtualMachine} Heap',
      values: {
        javaVirtualMachine: 'JVM'
      }
    }),
    value: (0, _format_number.formatMetric)(usedHeap, '0,0.[00]', '%', {
      prependSpace: false
    }),
    'data-test-subj': 'jvmHeap'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.nodeDetailStatus.freeDiskSpaceLabel', {
      defaultMessage: 'Free Disk Space'
    }),
    value: (0, _format_number.formatMetric)(freeSpace, '0.0 b') + ' (' + (0, _format_number.formatMetric)(percentSpaceUsed, '0,0.[00]', '%', {
      prependSpace: false
    }) + ')',
    'data-test-subj': 'freeDiskSpace'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.nodeDetailStatus.documentsLabel', {
      defaultMessage: 'Documents'
    }),
    value: (0, _format_number.formatMetric)(documents, '0.[0]a'),
    'data-test-subj': 'documentCount'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.nodeDetailStatus.dataLabel', {
      defaultMessage: 'Data'
    }),
    value: (0, _format_number.formatMetric)(dataSize, '0.0 b'),
    'data-test-subj': 'dataSize'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.nodeDetailStatus.indicesLabel', {
      defaultMessage: 'Indices'
    }),
    value: (0, _format_number.formatMetric)(indexCount, 'int_commas'),
    'data-test-subj': 'indicesCount'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.nodeDetailStatus.shardsLabel', {
      defaultMessage: 'Shards'
    }),
    value: (0, _format_number.formatMetric)(totalShards, 'int_commas'),
    'data-test-subj': 'shardsCount'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.nodeDetailStatus.typeLabel', {
      defaultMessage: 'Type'
    }),
    value: nodeTypeLabel,
    'data-test-subj': 'nodeType'
  }];
  const IconComponent = ({
    status,
    isOnline
  }) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_node.NodeStatusIcon, {
    status: status,
    isOnline: isOnline,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_summary_status.SummaryStatus, {
    metrics: metrics,
    status: status,
    isOnline: isOnline,
    IconComponent: IconComponent,
    "data-test-subj": "elasticsearchNodeDetailStatus",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 5
    }
  });
}