"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alertingRoutes = alertingRoutes;
var _app = require("../../common/constants/app");
var _error_wrapper = require("../client/error_wrapper");
var _alerting_schema = require("./schemas/alerting_schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function alertingRoutes({
  router,
  routeGuard
}, sharedServicesProviders) {
  /**
   * @apiGroup Alerting
   */
  router.versioned.post({
    access: 'internal',
    path: `${_app.ML_INTERNAL_BASE_PATH}/alerting/preview`,
    security: {
      authz: {
        requiredPrivileges: ['ml:canGetJobs']
      }
    },
    summary: 'Previews an alerting condition',
    description: 'Returns a preview of the alerting condition'
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: _alerting_schema.mlAnomalyDetectionAlertPreviewRequest
      }
    }
  }, routeGuard.fullLicenseAPIGuard(async ({
    mlClient,
    request,
    response,
    client,
    context
  }) => {
    try {
      const alertingService = sharedServicesProviders.alertingServiceProvider((await context.core).savedObjects.client, request);
      const result = await alertingService.preview(request.body);
      return response.ok({
        body: result
      });
    } catch (e) {
      return response.customError((0, _error_wrapper.wrapError)(e));
    }
  }));
}