"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterListsUI = exports.FilterLists = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = require("prop-types");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _header = require("./header");
var _table = require("./table");
var _toast_notification_service = require("../../../services/toast_notification_service");
var _help_menu = require("../../../components/help_menu");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/settings/filter_lists/list/filter_lists.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * React table for displaying a table of filter lists.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class FilterListsUI extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "setFilterLists", filterLists => {
      // Check selected filter lists still exist.
      this.setState(prevState => {
        const loadedFilterIds = filterLists.map(filterList => filterList.filter_id);
        const selectedFilterLists = prevState.selectedFilterLists.filter(filterList => {
          return loadedFilterIds.indexOf(filterList.filter_id) !== -1;
        });
        return {
          filterLists,
          selectedFilterLists
        };
      });
    });
    (0, _defineProperty2.default)(this, "setSelectedFilterLists", selectedFilterLists => {
      this.setState({
        selectedFilterLists
      });
    });
    (0, _defineProperty2.default)(this, "refreshFilterLists", () => {
      const mlApi = this.props.kibana.services.mlServices.mlApi;
      // Load the list of filters.
      mlApi.filters.filtersStats().then(filterLists => {
        this.setFilterLists(filterLists);
      }).catch(error => {
        console.log('Error loading list of filters:', error);
        const {
          toasts
        } = this.props.kibana.services.notifications;
        toasts.addDanger(_i18n.i18n.translate('xpack.ml.settings.filterLists.filterLists.loadingFilterListsErrorMessage', {
          defaultMessage: 'An error occurred loading the filter lists'
        }));
        const toastNotificationService = (0, _toast_notification_service.toastNotificationServiceProvider)(toasts);
        toastNotificationService.displayErrorToast(error, _i18n.i18n.translate('xpack.ml.settings.filterLists.filterLists.loadingFilterListsErrorMessage', {
          defaultMessage: 'An error occurred loading the filter lists'
        }));
      });
    });
    this.state = {
      filterLists: [],
      selectedFilterLists: []
    };
  }
  componentDidMount() {
    this.refreshFilterLists();
  }
  render() {
    const {
      filterLists,
      selectedFilterLists
    } = this.state;
    const {
      canCreateFilter,
      canDeleteFilter
    } = this.props;
    const helpLink = this.props.kibana.services.docLinks.links.ml.customRules;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "mlPageFilterListManagement",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_header.FilterListsHeader, {
      totalCount: filterLists.length,
      refreshFilterLists: this.refreshFilterLists,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_table.FilterListsTable, {
      canCreateFilter: canCreateFilter,
      canDeleteFilter: canDeleteFilter,
      filterLists: filterLists,
      selectedFilterLists: selectedFilterLists,
      setSelectedFilterLists: this.setSelectedFilterLists,
      refreshFilterLists: this.refreshFilterLists,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
      docLink: helpLink,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 9
      }
    }));
  }
}
exports.FilterListsUI = FilterListsUI;
(0, _defineProperty2.default)(FilterListsUI, "displayName", 'FilterLists');
(0, _defineProperty2.default)(FilterListsUI, "propTypes", {
  canCreateFilter: _propTypes.PropTypes.bool.isRequired,
  canDeleteFilter: _propTypes.PropTypes.bool.isRequired
});
const FilterLists = exports.FilterLists = (0, _public.withKibana)(FilterListsUI);