"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategoryStoppedPartitions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _kibana = require("../../../../../../../contexts/kibana");
var _job_creator_context = require("../../../job_creator_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/categorization_view/category_stopped_partitions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NUMBER_OF_PREVIEW = 5;
const CategoryStoppedPartitions = () => {
  const mlApi = (0, _kibana.useMlApi)();
  const {
    jobCreator: jc,
    resultsLoader
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const [tableRow, setTableRow] = (0, _react.useState)([]);
  const [stoppedPartitionsError, setStoppedPartitionsError] = (0, _react.useState)();
  const columns = (0, _react.useMemo)(() => [{
    field: 'partitionName',
    name: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.stoppedPartitionsPreviewColumnName', {
      defaultMessage: 'Stopped partition names'
    }),
    render: partition => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("code", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 13
      }
    }, partition))
  }], []);
  const loadCategoryStoppedPartitions = (0, _react.useCallback)(async () => {
    try {
      const {
        jobs
      } = await mlApi.results.getCategoryStoppedPartitions([jobCreator.jobId]);
      if (!Array.isArray(jobs) &&
      // if jobs is object of jobId: [partitions]
      Array.isArray(jobs[jobCreator.jobId]) && jobs[jobCreator.jobId].length > 0) {
        return jobs[jobCreator.jobId];
      }
    } catch (e) {
      const error = (0, _mlErrorUtils.extractErrorProperties)(e);
      // might get 404 because job has not been created yet and that's ok
      if (error.statusCode !== 404) {
        setStoppedPartitionsError(error.message);
      }
    }
    // skipping the ml service from deps
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreator.jobId]);
  (0, _react.useEffect)(() => {
    // only need to run this check if jobCreator.perPartitionStopOnWarn is turned on
    if (jobCreator.perPartitionCategorization && jobCreator.perPartitionStopOnWarn) {
      // subscribe to result updates
      const resultsSubscription = resultsLoader.results$.pipe((0, _rxjs.switchMap)(() => {
        return (0, _rxjs.from)(loadCategoryStoppedPartitions());
      }), (0, _rxjs.tap)(results => {
        if (Array.isArray(results)) {
          setTableRow(results.slice(0, NUMBER_OF_PREVIEW).map(partitionName => ({
            partitionName
          })));
        }
      }), (0, _rxjs.takeWhile)(results => {
        return !results || Array.isArray(results) && results.length <= NUMBER_OF_PREVIEW;
      })).subscribe();
      return () => resultsSubscription.unsubscribe();
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, stoppedPartitionsError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: 'danger',
    size: 's',
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.pickFieldsStep.stoppedPartitionsErrorCallout",
      defaultMessage: "An error occurred while fetching list of stopped partitions.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  })), Array.isArray(tableRow) && tableRow.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.pickFieldsStep.categorizationStoppedPartitionsTitle",
    defaultMessage: "Stopped partitions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: 'warning',
    size: 's',
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.pickFieldsStep.stoppedPartitionsExistCallout",
      defaultMessage: "Per-partition categorization and stop_on_warn settings are enabled. Some partitions in job ''{jobId}'' are unsuitable for categorization and have been excluded from further categorization or anomaly detection analysis.",
      values: {
        jobId: jobCreator.jobId
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: tableRow,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 11
    }
  })));
};
exports.CategoryStoppedPartitions = CategoryStoppedPartitions;