"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategorizationPerPartitionStopOnWarnSwitch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _job_creator_context = require("../../../job_creator_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/categorization_partition_field/categorization_stop_on_warn_switch.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CategorizationPerPartitionStopOnWarnSwitch = () => {
  const {
    jobCreator: jc,
    jobCreatorUpdate,
    jobCreatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const [stopOnWarn, setStopOnWarn] = (0, _react.useState)(jobCreator.perPartitionStopOnWarn);
  const toggleStopOnWarn = (0, _react.useCallback)(() => setStopOnWarn(!stopOnWarn), [stopOnWarn]);
  (0, _react.useEffect)(() => {
    jobCreator.perPartitionStopOnWarn = stopOnWarn;
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [stopOnWarn]);
  (0, _react.useEffect)(() => {
    setStopOnWarn(jobCreator.perPartitionStopOnWarn);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "categorizationPerPartitionStopOnWarnSwitch",
    disabled: false,
    checked: stopOnWarn,
    onChange: toggleStopOnWarn,
    "data-test-subj": "mlJobWizardSwitchCategorizationPerPartitionStopOnWarn",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.perPartitionCategorizationtopOnWarnSwitchLabel",
      defaultMessage: "Stop on warn",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  });
};
exports.CategorizationPerPartitionStopOnWarnSwitch = CategorizationPerPartitionStopOnWarnSwitch;